/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.core.parser.AntlrException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ANTLRPhaseErrors
extends Less4jException {
    private final List<AntlrException> errors;
    private String message;

    public ANTLRPhaseErrors(List<AntlrException> errors) {
        super("ANTLR detected one or more problems: ");
        this.errors = Collections.unmodifiableList(errors);
        this.message = "ANTLR detected one or more problems: " + this.getPositionInformation();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean hasErrorPosition() {
        return this.errors != null && !this.errors.isEmpty();
    }

    @Override
    public int getCharPositionInLine() {
        return -1;
    }

    @Override
    public int getLine() {
        return -1;
    }

    @Override
    protected String getPositionInformation() {
        String result = "";
        if (!this.hasErrorPosition()) {
            return result;
        }
        for (SimpleError error : this.getSimpleErrors()) {
            result = result + "\nLine: " + error.line + " Character: " + error.character;
            result = result + " " + error.message;
        }
        return result;
    }

    public List<SimpleError> getSimpleErrors() {
        ArrayList<SimpleError> result = new ArrayList<SimpleError>();
        for (AntlrException ex : this.errors) {
            result.add(new SimpleError(ex.getLine(), ex.getCharacter(), ex.getMessage()));
        }
        return result;
    }

    public static class SimpleError {
        private final int line;
        private final int character;
        private final String message;

        public SimpleError(int line, int character, String message) {
            this.line = line;
            this.character = character;
            this.message = message;
        }

        public int getLine() {
            return this.line;
        }

        public int getCharacter() {
            return this.character;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.character;
            result = 31 * result + this.line;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleError other = (SimpleError)obj;
            if (this.character != other.character) {
                return false;
            }
            if (this.line != other.line) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.line);
            builder.append(":");
            builder.append(this.character);
            builder.append(":");
            builder.append(this.message);
            return builder.toString();
        }
    }
}

