/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.NamedColorExpression;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.ParenthesesExpression;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.TreeBuildingException;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;

public class TermBuilder {
    private final ASTBuilderSwitch parentBuilder;

    public TermBuilder(ASTBuilderSwitch astBuilderSwitch) {
        this.parentBuilder = astBuilderSwitch;
    }

    public Expression buildFromTerm(HiddenTokenAwareTree token) {
        return this.buildFromTerm(token, 0);
    }

    public Expression buildFromTerm(HiddenTokenAwareTree token, int offsetChildIndx) {
        HiddenTokenAwareTree offsetChild = token.getChildren().get(offsetChildIndx);
        switch (offsetChild.getType()) {
            case 45: {
                return this.buildFromIdentifier(token, offsetChild);
            }
            case 37: {
                return this.buildFromString(token, offsetChild);
            }
            case 59: {
                return this.buildFromColorHash(token, offsetChild);
            }
            case 55: 
            case 57: {
                return this.negate(this.buildFromTerm(token, offsetChildIndx + 1), offsetChild);
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                return this.buildFromNumber(token, offsetChild);
            }
            case 40: {
                return this.buildFromSpecialFunction(token, offsetChild);
            }
            case 24: {
                return this.buildFromNormalFunction(token, offsetChild);
            }
            case 49: {
                return this.buildFromVariable(token, offsetChild);
            }
            case 51: {
                return this.buildFromIndirectVariable(token, offsetChild);
            }
            case 25: {
                return this.buildFromTerm(offsetChild);
            }
            case 13: {
                return this.buildFromParentheses(offsetChild);
            }
        }
        throw new TreeBuildingException("type number: " + PrintUtils.toName(offsetChild.getType()) + "(" + offsetChild.getType() + ") for " + offsetChild.getText(), offsetChild);
    }

    private Expression buildFromParentheses(HiddenTokenAwareTree first) {
        first.addBeforeFollowing(first.getLastChild().getFollowing());
        return new ParenthesesExpression(first, this.parentBuilder.handleExpression(first.getChild(1)));
    }

    private Expression buildFromColorHash(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        return new ColorExpression(token, first.getText());
    }

    private Expression negate(Expression value, HiddenTokenAwareTree sign) {
        if (value instanceof NumberExpression) {
            NumberExpression number = (NumberExpression)value;
            number.setExpliciteSign(true);
            if (sign.getType() == 57) {
                number.negate();
                number.setOriginalString("-" + number.getOriginalString());
            } else if (sign.getType() == 55) {
                number.setOriginalString("+" + number.getOriginalString());
            }
            return number;
        }
        if (sign.getType() == 57) {
            return new SignedExpression(sign, SignedExpression.Sign.MINUS, value);
        }
        return new SignedExpression(sign, SignedExpression.Sign.PLUS, value);
    }

    private NumberExpression buildFromNumber(HiddenTokenAwareTree token, HiddenTokenAwareTree actual) {
        NumberExpression result = new NumberExpression(token);
        String valueAsString = actual.getText().trim();
        this.setDoubleAndType(result, valueAsString);
        result.setOriginalString(valueAsString);
        result.setDimension(this.toDimension(actual));
        return result;
    }

    private void setDoubleAndType(NumberExpression result, String value) {
        value = value.toLowerCase().trim();
        String numberPart = value.replaceAll("[a-z%]", "");
        result.setValueAsDouble(Double.valueOf(numberPart));
        if (numberPart.length() < value.length()) {
            result.setSuffix(value.substring(numberPart.length()));
        } else {
            result.setSuffix("");
        }
    }

    private NumberExpression.Dimension toDimension(HiddenTokenAwareTree actual) {
        switch (actual.getType()) {
            case 62: {
                return NumberExpression.Dimension.NUMBER;
            }
            case 70: {
                return NumberExpression.Dimension.PERCENTAGE;
            }
            case 71: {
                return NumberExpression.Dimension.UNKNOWN;
            }
            case 69: {
                return NumberExpression.Dimension.REPEATER;
            }
            case 65: {
                return NumberExpression.Dimension.LENGTH;
            }
            case 63: {
                return NumberExpression.Dimension.EMS;
            }
            case 64: {
                return NumberExpression.Dimension.EXS;
            }
            case 66: {
                return NumberExpression.Dimension.ANGLE;
            }
            case 67: {
                return NumberExpression.Dimension.TIME;
            }
            case 68: {
                return NumberExpression.Dimension.FREQ;
            }
        }
        throw new TreeBuildingException("Unknown dimension type: " + actual.getType() + " " + actual.getText(), actual);
    }

    private Expression buildFromString(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        return this.createCssString(token, text);
    }

    public CssString createCssString(HiddenTokenAwareTree token, String quotedText) {
        return new CssString(token, quotedText.substring(1, quotedText.length() - 1), quotedText.substring(0, 1));
    }

    private Expression buildFromIdentifier(HiddenTokenAwareTree parent, HiddenTokenAwareTree first) {
        String text = first.getText();
        if (NamedColorExpression.isColorName(text)) {
            return new NamedColorExpression(parent, text);
        }
        return new IdentifierExpression(parent, text);
    }

    private FunctionExpression buildFromSpecialFunction(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        return new FunctionExpression(token, "url", this.extractUrlParameter(token, this.normalizeNewLineSymbols(first.getText())));
    }

    private String normalizeNewLineSymbols(String text) {
        return text.replaceAll("\r?\n", "\n");
    }

    private Expression extractUrlParameter(HiddenTokenAwareTree token, String text) {
        if (text == null) {
            return null;
        }
        if (text.length() < 5) {
            return new CssString(token, "", "");
        }
        String string = text.substring(4, text.length() - 1);
        return new CssString(token, string, "");
    }

    private FunctionExpression buildFromNormalFunction(HiddenTokenAwareTree token, HiddenTokenAwareTree actual) {
        List<HiddenTokenAwareTree> children = actual.getChildren();
        String name = children.get(0).getText();
        HiddenTokenAwareTree parameterNode = children.get(1);
        if (parameterNode.getType() != 73) {
            Expression parameter = (Expression)this.parentBuilder.switchOn(parameterNode);
            return new FunctionExpression(token, name, parameter);
        }
        HiddenTokenAwareTree parameterName = parameterNode.getChild(0);
        HiddenTokenAwareTree parameterValue = parameterNode.getChild(1);
        Expression parameter = (Expression)this.parentBuilder.switchOn(parameterValue);
        return new FunctionExpression(token, name, new NamedExpression(parameterNode, parameterName.getText(), parameter));
    }

    public Variable buildFromVariable(HiddenTokenAwareTree variableToken) {
        return this.buildFromVariable(null, variableToken);
    }

    private Variable buildFromVariable(HiddenTokenAwareTree expressionToken, HiddenTokenAwareTree variableToken) {
        if (expressionToken != null) {
            expressionToken.addFollowing(variableToken.getFollowing());
            return new Variable(expressionToken, variableToken.getText());
        }
        return new Variable(variableToken, variableToken.getText());
    }

    public IndirectVariable buildFromIndirectVariable(HiddenTokenAwareTree variableToken) {
        return this.buildFromIndirectVariable(null, variableToken);
    }

    private IndirectVariable buildFromIndirectVariable(HiddenTokenAwareTree expressionToken, HiddenTokenAwareTree variableToken) {
        if (expressionToken != null) {
            expressionToken.addFollowing(variableToken.getFollowing());
            return new IndirectVariable(expressionToken, variableToken.getText().substring(1));
        }
        return new IndirectVariable(variableToken, variableToken.getText().substring(1));
    }
}

