/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Name;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class Page
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private Name name;
    private boolean dockedPseudopage = true;
    private Name pseudopage;
    private GeneralBody body;

    public Page(HiddenTokenAwareTree token) {
        super(token);
    }

    public Page(HiddenTokenAwareTree token, Name name, Name pseudopage) {
        super(token);
        this.name = name;
        this.pseudopage = pseudopage;
    }

    public boolean hasDockedPseudopage() {
        return this.dockedPseudopage;
    }

    public void setDockedPseudopage(boolean dockedPseudopage) {
        this.dockedPseudopage = dockedPseudopage;
    }

    public Name getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Name getPseudopage() {
        return this.pseudopage;
    }

    public boolean hasPseudopage() {
        return this.getPseudopage() != null;
    }

    public void setPseudopage(Name pseudopage) {
        this.pseudopage = pseudopage;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    public List<ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.name, this.pseudopage, this.body);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.PAGE;
    }

    @Override
    public Page clone() {
        Page result = (Page)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.name = this.name == null ? null : this.name.clone();
        result.pseudopage = this.pseudopage == null ? null : this.pseudopage.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

