/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.compiler.expressions.IsColor;
import com.github.sommeri.less4j.core.compiler.expressions.IsEm;
import com.github.sommeri.less4j.core.compiler.expressions.IsKeyword;
import com.github.sommeri.less4j.core.compiler.expressions.IsNumber;
import com.github.sommeri.less4j.core.compiler.expressions.IsPercentage;
import com.github.sommeri.less4j.core.compiler.expressions.IsPixel;
import com.github.sommeri.less4j.core.compiler.expressions.IsString;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeFunctions
implements FunctionsPackage {
    protected static final String ISCOLOR = "iscolor";
    protected static final String ISKEYWORD = "iskeyword";
    protected static final String ISNUMBER = "isnumber";
    protected static final String ISSTRING = "isstring";
    protected static final String ISPIXEL = "ispixel";
    protected static final String ISPERCENTAGE = "ispercentage";
    protected static final String ISEM = "isem";
    private static Map<String, Function> FUNCTIONS = new HashMap<String, Function>();
    private final ProblemsHandler problemsHandler;

    public TypeFunctions(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    @Override
    public boolean canEvaluate(FunctionExpression input, List<Expression> parameters) {
        return FUNCTIONS.containsKey(input.getName());
    }

    @Override
    public Expression evaluate(FunctionExpression input, List<Expression> parameters, Expression evaluatedParameter) {
        if (!this.canEvaluate(input, parameters)) {
            return input;
        }
        Function function = FUNCTIONS.get(input.getName());
        return function.evaluate(parameters, this.problemsHandler, input, evaluatedParameter);
    }

    static {
        FUNCTIONS.put(ISCOLOR, new IsColor());
        FUNCTIONS.put(ISKEYWORD, new IsKeyword());
        FUNCTIONS.put(ISNUMBER, new IsNumber());
        FUNCTIONS.put(ISSTRING, new IsString());
        FUNCTIONS.put(ISPIXEL, new IsPixel());
        FUNCTIONS.put(ISPERCENTAGE, new IsPercentage());
        FUNCTIONS.put(ISEM, new IsEm());
    }
}

