/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.jaxrsclienttest;

import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentInfo;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JaxRsTestExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback,
Extension {
    private static UndertowJaxrsServer SERVER;
    private static Set<Object> SINGLETONS;
    private int port = 0;
    private String contextPath = "/";
    private URI baseUri;
    private int nesting = 0;
    private Client jaxRsClient;

    public JaxRsTestExtension() {
    }

    public JaxRsTestExtension(Object ... resources) {
        SINGLETONS = new HashSet<Object>(Arrays.asList(resources));
        SINGLETONS.forEach(this::checkSingleton);
    }

    private void checkSingleton(Object singleton) {
        if (singleton instanceof Class) {
            throw new IllegalArgumentException("the singleton <" + singleton + "> passed into " + JaxRsTestExtension.class.getSimpleName() + " is a class, not an instance");
        }
    }

    public JaxRsTestExtension port(int port) {
        this.port = port;
        return this;
    }

    public JaxRsTestExtension contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public void beforeAll(ExtensionContext context) {
        this.start();
    }

    public void beforeEach(ExtensionContext context) {
        this.start();
    }

    public void afterEach(ExtensionContext context) {
        this.stop();
    }

    public void afterAll(ExtensionContext context) {
        this.stop();
    }

    public void start() {
        ++this.nesting;
        if (this.nesting == 1) {
            assert (SERVER == null);
            SERVER = new UndertowJaxrsServer().start(Undertow.builder().addHttpListener(this.port, "localhost"));
            this.baseUri = this.getBaseUri();
            this.deployDummyApp();
        }
    }

    private URI getBaseUri() {
        Undertow undertow = JaxRsTestExtension.getField(SERVER, "server", Undertow.class);
        Undertow.ListenerInfo listenerInfo = (Undertow.ListenerInfo)undertow.getListenerInfo().iterator().next();
        InetSocketAddress socketAddress = (InetSocketAddress)listenerInfo.getAddress();
        return URI.create(listenerInfo.getProtcol() + "://" + socketAddress.getHostString() + ":" + socketAddress.getPort() + this.contextPath);
    }

    private static <T> T getField(Object instance, String fieldName, Class<T> type) {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return type.cast(field.get(instance));
    }

    private void deployDummyApp() {
        Class<?> firstResource = SINGLETONS.iterator().next().getClass();
        try {
            DeploymentInfo deploymentInfo = SERVER.undertowDeployment(DummyApp.class);
            deploymentInfo.setClassLoader(firstResource.getClassLoader() != null ? firstResource.getClassLoader() : ClassLoader.getSystemClassLoader());
            deploymentInfo.setContextPath(this.contextPath);
            deploymentInfo.setDeploymentName(firstResource.getSimpleName());
            SERVER.deploy(deploymentInfo);
        }
        catch (Throwable e) {
            throw new RuntimeException("can't deploy " + firstResource, e);
        }
    }

    public void stop() {
        --this.nesting;
        if (this.nesting == 0) {
            assert (SERVER != null);
            SERVER.stop();
            SERVER = null;
            SINGLETONS = null;
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public Response GET(String path) {
        return this.target().path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
    }

    public WebTarget target() {
        return this.client().target(this.baseUri());
    }

    public Client client() {
        if (this.jaxRsClient == null) {
            this.jaxRsClient = ClientBuilder.newClient();
        }
        return this.jaxRsClient;
    }

    static {
        SINGLETONS = null;
    }

    public static class DummyApp
    extends Application {
        public Set<Object> getSingletons() {
            return SINGLETONS;
        }
    }
}

