/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.builder.BuilderTools;
import com.github.tennaito.rsql.parser.ast.ComparisonOperatorProxy;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PredicateBuilder {
    private static final Logger LOG = Logger.getLogger(PredicateBuilder.class.getName());
    public static final Character LIKE_WILDCARD = Character.valueOf('*');

    private PredicateBuilder() {
    }

    public static <T> Predicate createPredicate(Node node, From root, Class<T> entity, EntityManager manager, BuilderTools misc) {
        LOG.log(Level.INFO, "Creating Predicate for: {0}", node);
        if (node instanceof LogicalNode) {
            return PredicateBuilder.createPredicate((LogicalNode)node, root, entity, manager, misc);
        }
        if (node instanceof ComparisonNode) {
            return PredicateBuilder.createPredicate((ComparisonNode)node, root, entity, manager, misc);
        }
        throw new IllegalArgumentException("Unknown expression type: " + node.getClass());
    }

    public static <T> Predicate createPredicate(LogicalNode logical, From root, Class<T> entity, EntityManager entityManager, BuilderTools misc) {
        LOG.log(Level.INFO, "Creating Predicate for logical node: {0}", logical);
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        LOG.log(Level.INFO, "Creating Predicates from all children nodes.");
        for (Node node : logical.getChildren()) {
            predicates.add(PredicateBuilder.createPredicate(node, root, entity, entityManager, misc));
        }
        switch (logical.getOperator()) {
            case AND: {
                return builder.and(predicates.toArray(new Predicate[predicates.size()]));
            }
            case OR: {
                return builder.or(predicates.toArray(new Predicate[predicates.size()]));
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + logical.getOperator());
    }

    public static <T> Predicate createPredicate(ComparisonNode comparison, From startRoot, Class<T> entity, EntityManager entityManager, BuilderTools misc) {
        if (startRoot == null) {
            String msg = "From root node was undefined.";
            LOG.log(Level.SEVERE, msg);
            throw new IllegalArgumentException(msg);
        }
        LOG.log(Level.INFO, "Creating Predicate for comparison node: {0}", comparison);
        Metamodel metaModel = entityManager.getMetamodel();
        ManagedType classMetadata = metaModel.managedType(entity);
        From root = startRoot;
        Class<?> argumentType = null;
        Expression propertyPath = null;
        String[] graph = comparison.getSelector().split("\\.");
        LOG.log(Level.INFO, "Property graph path : {0}", comparison.getSelector());
        for (String property : graph) {
            String mappedProperty = misc.getPropertiesMapper().translate(property, classMetadata.getJavaType());
            if (PredicateBuilder.hasPropertyName(mappedProperty, classMetadata)) {
                argumentType = PredicateBuilder.findPropertyType(mappedProperty, classMetadata);
                if (!PredicateBuilder.isAssociationType(mappedProperty, classMetadata)) {
                    LOG.log(Level.INFO, "Create property path for type {0} property {1}.", new Object[]{classMetadata.getJavaType().getName(), mappedProperty});
                    propertyPath = root.get(mappedProperty).as(argumentType);
                    break;
                }
            } else {
                throw new IllegalArgumentException("Unknown property: " + mappedProperty + " from entity " + classMetadata.getJavaType().getName());
            }
            String previousClass = classMetadata.getJavaType().getName();
            classMetadata = metaModel.managedType(argumentType);
            LOG.log(Level.INFO, "Create a join between {0} and {1}.", new Object[]{previousClass, classMetadata.getJavaType().getName()});
            root = root.join(mappedProperty);
        }
        LOG.log(Level.INFO, "Cast all arguments to type {0}.", argumentType.getName());
        List<Object> castedArguments = misc.getArgumentParser().parse(comparison.getArguments(), argumentType);
        try {
            return PredicateBuilder.createPredicate(propertyPath, comparison.getOperator(), castedArguments, entityManager);
        }
        catch (IllegalArgumentException e) {
            if (misc.getPredicateBuilder() != null) {
                return misc.getPredicateBuilder().createPredicate((Node)comparison, startRoot, entity, entityManager, misc);
            }
            throw e;
        }
    }

    private static Predicate createPredicate(Expression propertyPath, ComparisonOperator operator, List<Object> arguments, EntityManager manager) {
        LOG.log(Level.INFO, "Creating predicate: propertyPath {0} {1}", new Object[]{operator, arguments});
        if (ComparisonOperatorProxy.asEnum(operator) != null) {
            switch (ComparisonOperatorProxy.asEnum(operator)) {
                case EQUAL: {
                    Object argument = arguments.get(0);
                    if (argument instanceof String) {
                        return PredicateBuilder.createLike((Expression<String>)propertyPath, (String)argument, manager);
                    }
                    if (PredicateBuilder.isNullArgument(argument)) {
                        return PredicateBuilder.createIsNull(propertyPath, manager);
                    }
                    return PredicateBuilder.createEqual(propertyPath, argument, manager);
                }
                case NOT_EQUAL: {
                    Object argument = arguments.get(0);
                    if (argument instanceof String) {
                        return PredicateBuilder.createNotLike((Expression<String>)propertyPath, (String)argument, manager);
                    }
                    if (PredicateBuilder.isNullArgument(argument)) {
                        return PredicateBuilder.createIsNotNull(propertyPath, manager);
                    }
                    return PredicateBuilder.createNotEqual(propertyPath, argument, manager);
                }
                case GREATER_THAN: {
                    Object argument = arguments.get(0);
                    return PredicateBuilder.createGreaterThan((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                }
                case GREATER_THAN_OR_EQUAL: {
                    Object argument = arguments.get(0);
                    return PredicateBuilder.createGreaterEqual((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                }
                case LESS_THAN: {
                    Object argument = arguments.get(0);
                    return PredicateBuilder.createLessThan((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                }
                case LESS_THAN_OR_EQUAL: {
                    Object argument = arguments.get(0);
                    return PredicateBuilder.createLessEqual((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                }
                case IN: {
                    return PredicateBuilder.createIn(propertyPath, arguments, manager);
                }
                case NOT_IN: {
                    return PredicateBuilder.createNotIn(propertyPath, arguments, manager);
                }
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    private static Predicate createLike(Expression<String> propertyPath, String argument, EntityManager manager) {
        String like = argument.replace(LIKE_WILDCARD.charValue(), '%');
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.like(builder.lower(propertyPath), like.toLowerCase());
    }

    private static Predicate createIsNull(Expression<?> propertyPath, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.isNull(propertyPath);
    }

    private static Predicate createEqual(Expression<?> propertyPath, Object argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.equal(propertyPath, argument);
    }

    private static Predicate createNotEqual(Expression<?> propertyPath, Object argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.notEqual(propertyPath, argument);
    }

    private static Predicate createNotLike(Expression<String> propertyPath, String argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.not((Expression)PredicateBuilder.createLike(propertyPath, argument, manager));
    }

    private static Predicate createIsNotNull(Expression<?> propertyPath, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.isNotNull(propertyPath);
    }

    private static Predicate createGreaterThan(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.gt(propertyPath, argument);
    }

    private static Predicate createGreaterEqual(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.ge(propertyPath, argument);
    }

    private static Predicate createLessThan(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lt(propertyPath, argument);
    }

    private static Predicate createLessEqual(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.le(propertyPath, argument);
    }

    private static Predicate createIn(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        return propertyPath.in(arguments);
    }

    private static Predicate createNotIn(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.not((Expression)PredicateBuilder.createIn(propertyPath, arguments, manager));
    }

    private static <T> boolean isAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation();
    }

    private static <T> boolean hasPropertyName(String property, ManagedType<T> classMetadata) {
        Set names = classMetadata.getAttributes();
        for (Attribute name : names) {
            if (!name.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    private static <T> Class<?> findPropertyType(String property, ManagedType<T> classMetadata) {
        Class propertyType = null;
        propertyType = classMetadata.getAttribute(property).isCollection() ? ((PluralAttribute)classMetadata.getAttribute(property)).getBindableJavaType() : classMetadata.getAttribute(property).getJavaType();
        return propertyType;
    }

    private static boolean isNullArgument(Object argument) {
        return argument == null;
    }
}

