/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.GetAllScenariosTask;
import com.github.tomakehurst.wiremock.admin.GetRecordingStatusTask;
import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.admin.StartRecordingTask;
import com.github.tomakehurst.wiremock.admin.StopRecordingTask;
import com.github.tomakehurst.wiremock.admin.tasks.CreateStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.DeleteStubFileTask;
import com.github.tomakehurst.wiremock.admin.tasks.EditStubFileTask;
import com.github.tomakehurst.wiremock.admin.tasks.EditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubFilesTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetDocIndexTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRamlSpecTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRecordingsIndexTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetServedStubTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetSwaggerSpecTask;
import com.github.tomakehurst.wiremock.admin.tasks.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.tasks.NotFoundAdminTask;
import com.github.tomakehurst.wiremock.admin.tasks.OldCreateStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.OldEditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.OldRemoveStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.OldResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.RootRedirectTask;
import com.github.tomakehurst.wiremock.admin.tasks.RootTask;
import com.github.tomakehurst.wiremock.admin.tasks.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.tasks.SnapshotTask;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.verification.notmatched.PlainTextStubNotMatchedRenderer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;

public class AdminRoutes {
    private final ImmutableBiMap<RequestSpec, AdminTask> routes;
    private final Iterable<AdminApiExtension> apiExtensions;

    public static AdminRoutes defaults() {
        return new AdminRoutes(Collections.emptyList(), new PlainTextStubNotMatchedRenderer());
    }

    public static AdminRoutes defaultsPlus(Iterable<AdminApiExtension> apiExtensions, AdminTask notMatchedTask) {
        return new AdminRoutes(apiExtensions, notMatchedTask);
    }

    protected AdminRoutes(Iterable<AdminApiExtension> apiExtensions, AdminTask notMatchedTask) {
        this.apiExtensions = apiExtensions;
        RouteBuilder routeBuilder = new RouteBuilder();
        this.initDefaultRoutes(routeBuilder);
        this.initAdditionalRoutes(routeBuilder);
        routeBuilder.add(RequestMethod.ANY, "/not-matched", notMatchedTask);
        this.routes = routeBuilder.build();
    }

    private void initDefaultRoutes(Router router) {
        router.add(RequestMethod.GET, "/", RootTask.class);
        router.add(RequestMethod.GET, "", RootRedirectTask.class);
        router.add(RequestMethod.POST, "/reset", ResetTask.class);
        router.add(RequestMethod.GET, "/mappings", GetAllStubMappingsTask.class);
        router.add(RequestMethod.POST, "/mappings", CreateStubMappingTask.class);
        router.add(RequestMethod.DELETE, "/mappings", ResetStubMappingsTask.class);
        router.add(RequestMethod.POST, "/mappings/new", OldCreateStubMappingTask.class);
        router.add(RequestMethod.POST, "/mappings/remove", OldRemoveStubMappingTask.class);
        router.add(RequestMethod.POST, "/mappings/edit", OldEditStubMappingTask.class);
        router.add(RequestMethod.POST, "/mappings/save", SaveMappingsTask.class);
        router.add(RequestMethod.POST, "/mappings/reset", ResetToDefaultMappingsTask.class);
        router.add(RequestMethod.GET, "/mappings/{id}", GetStubMappingTask.class);
        router.add(RequestMethod.PUT, "/mappings/{id}", EditStubMappingTask.class);
        router.add(RequestMethod.DELETE, "/mappings/{id}", RemoveStubMappingTask.class);
        router.add(RequestMethod.GET, "/files", GetAllStubFilesTask.class);
        router.add(RequestMethod.PUT, "/files/{filename}", EditStubFileTask.class);
        router.add(RequestMethod.DELETE, "/files/{filename}", DeleteStubFileTask.class);
        router.add(RequestMethod.GET, "/scenarios", GetAllScenariosTask.class);
        router.add(RequestMethod.POST, "/scenarios/reset", ResetScenariosTask.class);
        router.add(RequestMethod.GET, "/requests", GetAllRequestsTask.class);
        router.add(RequestMethod.DELETE, "/requests", ResetRequestsTask.class);
        router.add(RequestMethod.POST, "/requests/reset", OldResetRequestsTask.class);
        router.add(RequestMethod.POST, "/requests/count", GetRequestCountTask.class);
        router.add(RequestMethod.POST, "/requests/find", FindRequestsTask.class);
        router.add(RequestMethod.GET, "/requests/unmatched", FindUnmatchedRequestsTask.class);
        router.add(RequestMethod.GET, "/requests/unmatched/near-misses", FindNearMissesForUnmatchedTask.class);
        router.add(RequestMethod.GET, "/requests/{id}", GetServedStubTask.class);
        router.add(RequestMethod.POST, "/recordings/snapshot", SnapshotTask.class);
        router.add(RequestMethod.POST, "/recordings/start", StartRecordingTask.class);
        router.add(RequestMethod.POST, "/recordings/stop", StopRecordingTask.class);
        router.add(RequestMethod.GET, "/recordings/status", GetRecordingStatusTask.class);
        router.add(RequestMethod.GET, "/recorder", GetRecordingsIndexTask.class);
        router.add(RequestMethod.POST, "/near-misses/request", FindNearMissesForRequestTask.class);
        router.add(RequestMethod.POST, "/near-misses/request-pattern", FindNearMissesForRequestPatternTask.class);
        router.add(RequestMethod.POST, "/settings", GlobalSettingsUpdateTask.class);
        router.add(RequestMethod.POST, "/shutdown", ShutdownServerTask.class);
        router.add(RequestMethod.GET, "/docs/raml", GetRamlSpecTask.class);
        router.add(RequestMethod.GET, "/docs/swagger", GetSwaggerSpecTask.class);
        router.add(RequestMethod.GET, "/docs", GetDocIndexTask.class);
    }

    protected void initAdditionalRoutes(Router routeBuilder) {
        for (AdminApiExtension apiExtension : this.apiExtensions) {
            apiExtension.contributeAdminApiRoutes(routeBuilder);
        }
    }

    public AdminTask taskFor(final RequestMethod method, final String path) {
        return (AdminTask)Iterables.tryFind((Iterable)this.routes.entrySet(), (Predicate)new Predicate<Map.Entry<RequestSpec, AdminTask>>(){

            public boolean apply(Map.Entry<RequestSpec, AdminTask> entry) {
                return entry.getKey().matches(method, path);
            }
        }).transform((Function)new Function<Map.Entry<RequestSpec, AdminTask>, AdminTask>(){

            public AdminTask apply(Map.Entry<RequestSpec, AdminTask> input) {
                return input.getValue();
            }
        }).or((Object)new NotFoundAdminTask());
    }

    public RequestSpec requestSpecForTask(final Class<? extends AdminTask> taskClass) {
        RequestSpec requestSpec = (RequestSpec)Iterables.tryFind((Iterable)this.routes.entrySet(), (Predicate)new Predicate<Map.Entry<RequestSpec, AdminTask>>(){

            public boolean apply(Map.Entry<RequestSpec, AdminTask> input) {
                return input.getValue().getClass().equals(taskClass);
            }
        }).transform((Function)new Function<Map.Entry<RequestSpec, AdminTask>, RequestSpec>(){

            public RequestSpec apply(Map.Entry<RequestSpec, AdminTask> input) {
                return input.getKey();
            }
        }).orNull();
        if (requestSpec == null) {
            throw new NotFoundException("No route could be found for " + taskClass.getSimpleName());
        }
        return requestSpec;
    }

    protected static class RouteBuilder
    implements Router {
        private final ImmutableBiMap.Builder<RequestSpec, AdminTask> builder = ImmutableBiMap.builder();

        @Override
        public void add(RequestMethod method, String urlTemplate, Class<? extends AdminTask> taskClass) {
            try {
                AdminTask task = taskClass.newInstance();
                this.add(RequestSpec.requestSpec(method, urlTemplate), task);
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }

        @Override
        public void add(RequestMethod method, String urlTemplate, AdminTask task) {
            this.add(RequestSpec.requestSpec(method, urlTemplate), task);
        }

        public void add(RequestSpec requestSpec, AdminTask task) {
            this.builder.put((Object)requestSpec, (Object)task);
        }

        ImmutableBiMap<RequestSpec, AdminTask> build() {
            return this.builder.build();
        }
    }
}

