/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;

public class XsdParser
extends XsdParserCore {
    public XsdParser(String filePath) {
        this.schemaLocations.add(filePath);
        for (int index = 0; this.schemaLocations.size() > index; ++index) {
            String schemaLocation = (String)this.schemaLocations.get(index);
            this.parseFile(schemaLocation);
        }
        this.resolveRefs();
    }

    private void parseFile(String filePath) {
        try {
            if (!new File(filePath).exists()) {
                throw new FileNotFoundException();
            }
            Node schemaNode = this.getSchemaNode(filePath);
            if (!this.isXsdSchema(schemaNode)) {
                throw new ParsingException("The top level element of a XSD file should be the xsd:schema node.");
            }
            XsdSchema.parse(this, schemaNode);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while parsing.", e);
        }
    }

    private Node getSchemaNode(String filePath) throws IOException, SAXException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(filePath);
        doc.getDocumentElement().normalize();
        return doc.getFirstChild();
    }
}

