/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Arrays;
import java.util.Optional;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.enums.XsdEnum;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;

public class AttributeValidations {
    private AttributeValidations() {
    }

    public static <T extends XsdEnum> T belongsToEnum(XsdEnum<T> instance, String value) {
        if (value == null) {
            return null;
        }
        Optional<XsdEnum> enumValue = Arrays.stream(instance.getValues()).filter(enumField -> enumField.getValue().equals(value)).findFirst();
        if (enumValue.isPresent()) {
            return (T)enumValue.get();
        }
        StringBuilder possibleValues = new StringBuilder();
        instance.getSupportedValues().forEach(supportedValue -> possibleValues.append((String)supportedValue).append(", "));
        String values = possibleValues.toString();
        values = values.substring(0, values.length() - 2);
        throw new ParsingException("The attribute " + instance.getVariableName() + " doesn't support the value \"" + value + "\".\nThe possible values for the " + instance.getVariableName() + " attribute are:\n" + values);
    }

    static String maxOccursValidation(String elementName, String value) {
        if (value.equals("unbounded")) {
            return value;
        }
        AttributeValidations.validateNonNegativeInteger(elementName, "maxOccurs", value);
        return value;
    }

    static Integer validateNonNegativeInteger(String elementName, String attributeName, String value) {
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0) {
                throw new ParsingException("The " + elementName + " " + attributeName + " attribute should be a non negative integer. (greater or equal than 0)");
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ParsingException("The " + elementName + " " + attributeName + "  attribute should be a non negative integer.");
        }
    }

    public static Integer validateRequiredNonNegativeInteger(String elementName, String attributeName, String value) {
        if (value == null) {
            throw new ParsingException(AttributeValidations.attributeMissingMessage(elementName, attributeName));
        }
        return AttributeValidations.validateNonNegativeInteger(elementName, attributeName, value);
    }

    private static Integer validatePositiveInteger(String elementName, String attributeName, String value) {
        try {
            int intValue = Integer.parseInt(value);
            if (intValue <= 0) {
                throw new ParsingException("The " + elementName + " " + attributeName + "  attribute should be a positive integer. (greater than 0)");
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ParsingException("The " + elementName + " " + attributeName + "  attribute should be a positive integer.");
        }
    }

    public static Integer validateRequiredPositiveInteger(String elementName, String attributeName, String value) {
        if (value == null) {
            throw new ParsingException(AttributeValidations.attributeMissingMessage(elementName, attributeName));
        }
        return AttributeValidations.validatePositiveInteger(elementName, attributeName, value);
    }

    public static Boolean validateBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    private static Double validateDouble(String elementName, String attributeName, String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("The " + elementName + " " + attributeName + "  attribute should be a numeric value.");
        }
    }

    public static Double validateRequiredDouble(String elementName, String attributeName, String value) {
        if (value == null) {
            throw new ParsingException(AttributeValidations.attributeMissingMessage(elementName, attributeName));
        }
        return AttributeValidations.validateDouble(elementName, attributeName, value);
    }

    static String getFormDefaultValue(XsdAbstractElement parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof XsdSchema) {
            return ((XsdSchema)parent).getElementFormDefault();
        }
        return AttributeValidations.getFormDefaultValue(parent.getParent());
    }

    static String getFinalDefaultValue(XsdAbstractElement parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof XsdSchema) {
            return ((XsdSchema)parent).getFinalDefault();
        }
        return AttributeValidations.getFinalDefaultValue(parent.getParent());
    }

    static String getBlockDefaultValue(XsdAbstractElement parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof XsdSchema) {
            return ((XsdSchema)parent).getBlockDefault();
        }
        return AttributeValidations.getBlockDefaultValue(parent.getParent());
    }

    private static String attributeMissingMessage(String elementName, String attributeName) {
        return "The " + elementName + " " + attributeName + " is required to have a value attribute.";
    }
}

