/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdRestriction;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.enums.FormEnum;
import org.xmlet.xsdparser.xsdelements.enums.UsageEnum;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAttributeVisitor;

public class XsdAttribute
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:attribute";
    public static final String XS_TAG = "xs:attribute";
    private XsdAttributeVisitor visitor = new XsdAttributeVisitor(this);
    private ReferenceBase simpleType;
    private String defaultElement;
    private String fixed;
    private String type;
    private FormEnum form;
    private UsageEnum use;

    private XsdAttribute(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        String formDefaultValue = XsdAttribute.getFormDefaultValue(this.parent);
        this.defaultElement = attributesMap.getOrDefault("defaultElement", this.defaultElement);
        this.fixed = attributesMap.getOrDefault("fixed", this.fixed);
        this.type = attributesMap.getOrDefault("type", this.type);
        this.form = AttributeValidations.belongsToEnum(FormEnum.QUALIFIED, attributesMap.getOrDefault("form", formDefaultValue));
        this.use = AttributeValidations.belongsToEnum(UsageEnum.OPTIONAL, attributesMap.getOrDefault("use", UsageEnum.OPTIONAL.getValue()));
        if (this.type != null && !XsdParser.getXsdTypesToJava().containsKey(this.type)) {
            this.simpleType = new UnsolvedReference(this.type, new XsdAttribute(this, parser, new HashMap<String, String>()));
            parser.addUnsolvedReference((UnsolvedReference)this.simpleType);
        }
    }

    private XsdAttribute(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        this(parser, attributesMap);
        this.setParent(parent);
    }

    private static String getFormDefaultValue(XsdAbstractElement parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof XsdElement) {
            return ((XsdElement)parent).getForm();
        }
        if (parent instanceof XsdSchema) {
            return ((XsdSchema)parent).getAttributeFormDefault();
        }
        return XsdAttribute.getFormDefaultValue(parent.getParent());
    }

    @Override
    public void validateSchemaRules() {
        super.validateSchemaRules();
        this.rule2();
        this.rule3();
    }

    private void rule3() {
        if (this.attributesMap.containsKey("ref") && (this.simpleType != null || this.form != null || this.type != null)) {
            throw new ParsingException("xsd:attribute element: If ref attribute is present, simpleType element, form attribute and type attribute cannot be present at the same time.");
        }
    }

    private void rule2() {
        if (this.fixed != null && this.defaultElement != null) {
            throw new ParsingException("xsd:attribute element: fixed and defaultElement attributes are not allowed at the same time.");
        }
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdAttributeVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public XsdAttribute clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("type");
        placeHolderAttributes.remove("ref");
        XsdAttribute copy = new XsdAttribute(this.parent, this.parser, placeHolderAttributes);
        copy.type = this.type;
        copy.simpleType = this.simpleType;
        return copy;
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement elementWrapper) {
        super.replaceUnsolvedElements(elementWrapper);
        XsdNamedElements element = elementWrapper.getElement();
        if (element instanceof XsdSimpleType && this.simpleType != null && this.type.equals(elementWrapper.getName())) {
            this.simpleType = elementWrapper;
        }
    }

    public void setSimpleType(ReferenceBase simpleType) {
        this.simpleType = simpleType;
    }

    public XsdSimpleType getXsdSimpleType() {
        return this.simpleType instanceof ConcreteElement ? (XsdSimpleType)this.simpleType.getElement() : null;
    }

    public String getType() {
        return this.type;
    }

    public String getUse() {
        return this.use.getValue();
    }

    public String getForm() {
        return this.form.getValue();
    }

    public String getFixed() {
        return this.fixed;
    }

    public List<XsdRestriction> getAllRestrictions() {
        XsdSimpleType simpleTypeObj = this.getXsdSimpleType();
        if (simpleTypeObj != null) {
            return simpleTypeObj.getAllRestrictions();
        }
        return Collections.emptyList();
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdAttribute.xsdParseSkeleton(node, new XsdAttribute(parser, XsdAttribute.convertNodeMap(node.getAttributes())));
    }
}

