/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Map;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdChoiceVisitor;

public class XsdChoice
extends XsdMultipleElements {
    public static final String XSD_TAG = "xsd:choice";
    public static final String XS_TAG = "xs:choice";
    private XsdChoiceVisitor visitor = new XsdChoiceVisitor(this);
    private Integer minOccurs;
    private String maxOccurs;

    private XsdChoice(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", attributesMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.maxOccursValidation(XSD_TAG, attributesMap.getOrDefault("maxOccurs", "1"));
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdChoiceVisitor getVisitor() {
        return this.visitor;
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdChoice.xsdParseSkeleton(node, new XsdChoice(parser, XsdChoice.convertNodeMap(node.getAttributes())));
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public Stream<XsdChoice> getChildrenChoices() {
        return this.getElements().stream().filter(element -> element.getElement() instanceof XsdChoice).map(element -> (XsdChoice)element.getElement());
    }

    public Stream<XsdElement> getChildrenElements() {
        return this.getElements().stream().filter(element -> element.getElement() instanceof XsdElement).map(element -> (XsdElement)element.getElement());
    }

    public Stream<XsdSequence> getChildrenSequences() {
        return this.getElements().stream().filter(element -> element.getElement() instanceof XsdSequence).map(element -> (XsdSequence)element.getElement());
    }

    public Stream<XsdGroup> getChildrenGroups() {
        return this.getElements().stream().filter(element -> element.getElement() instanceof XsdGroup).map(element -> (XsdGroup)element.getElement());
    }
}

