/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdExtension;
import org.xmlet.xsdparser.xsdelements.XsdRestriction;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdComplexContentVisitor;

public class XsdComplexContent
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:complexContent";
    public static final String XS_TAG = "xs:complexContent";
    private XsdComplexContentVisitor visitor = new XsdComplexContentVisitor(this);
    private ReferenceBase restriction;
    private ReferenceBase extension;
    private boolean mixed;

    private XsdComplexContent(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        this.mixed = AttributeValidations.validateBoolean(attributesMap.getOrDefault("mixed", "false"));
    }

    @Override
    public XsdComplexContentVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public XsdExtension getXsdExtension() {
        return this.extension instanceof ConcreteElement ? (XsdExtension)this.extension.getElement() : null;
    }

    public XsdRestriction getXsdRestriction() {
        return this.restriction instanceof ConcreteElement ? (XsdRestriction)this.restriction.getElement() : null;
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdComplexContent.xsdParseSkeleton(node, new XsdComplexContent(parser, XsdComplexContent.convertNodeMap(node.getAttributes())));
    }

    public void setExtension(ReferenceBase extension) {
        this.extension = extension;
    }

    public void setRestriction(ReferenceBase restriction) {
        this.restriction = restriction;
    }
}

