/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdComplexContent;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.XsdSimpleContent;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.enums.ComplexTypeBlockEnum;
import org.xmlet.xsdparser.xsdelements.enums.FinalEnum;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdComplexTypeVisitor;

public class XsdComplexType
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:complexType";
    public static final String XS_TAG = "xs:complexType";
    private XsdComplexTypeVisitor visitor = new XsdComplexTypeVisitor(this);
    private ReferenceBase childElement;
    private boolean elementAbstract;
    private boolean mixed;
    private ComplexTypeBlockEnum block;
    private FinalEnum elementFinal;
    private XsdComplexContent complexContent;
    private XsdSimpleContent simpleContent;

    XsdComplexType(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        String blockDefault = AttributeValidations.getBlockDefaultValue(this.parent);
        String finalDefault = AttributeValidations.getFinalDefaultValue(this.parent);
        this.elementAbstract = AttributeValidations.validateBoolean(attributesMap.getOrDefault("abstract", "false"));
        this.mixed = AttributeValidations.validateBoolean(attributesMap.getOrDefault("mixed", "false"));
        this.block = AttributeValidations.belongsToEnum(ComplexTypeBlockEnum.ALL, attributesMap.getOrDefault("block", blockDefault));
        this.elementFinal = AttributeValidations.belongsToEnum(FinalEnum.ALL, attributesMap.getOrDefault("final", finalDefault));
    }

    XsdComplexType(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> elementFieldsMapParam) {
        this(parser, elementFieldsMapParam);
        this.setParent(parent);
    }

    @Override
    public void validateSchemaRules() {
        super.validateSchemaRules();
        this.rule2();
    }

    private void rule2() {
        if (this.simpleContent != null && this.attributesMap.containsKey("mixed")) {
            throw new ParsingException("xsd:complexType element: The simpleContent element and the mixed attribute are not allowed at the same time.");
        }
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdComplexTypeVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.childElement == null ? null : this.childElement.getElement().getElements();
    }

    @Override
    public XsdComplexType clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("ref");
        XsdComplexType elementCopy = new XsdComplexType(this.parent, this.parser, placeHolderAttributes);
        elementCopy.childElement = this.childElement;
        elementCopy.visitor.setAttributes(this.visitor.getAttributes());
        elementCopy.visitor.setAttributeGroups(this.visitor.getAttributeGroups());
        elementCopy.complexContent = this.complexContent;
        elementCopy.simpleContent = this.simpleContent;
        return elementCopy;
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        super.replaceUnsolvedElements(element);
        this.visitor.replaceUnsolvedAttributes(element);
        if (this.childElement instanceof UnsolvedReference && this.childElement.getElement() instanceof XsdGroup && element.getElement() instanceof XsdGroup && ((UnsolvedReference)this.childElement).getRef().equals(element.getName())) {
            this.childElement = element;
            element.getElement().setParent(this);
        }
    }

    public XsdAbstractElement getXsdChildElement() {
        return this.childElement == null ? null : this.childElement.getElement();
    }

    public String getFinal() {
        return this.elementFinal.getValue();
    }

    List<ReferenceBase> getAttributes() {
        return this.visitor.getAttributes();
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return this.visitor.getXsdAttributes();
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroup() {
        return this.visitor.getXsdAttributeGroup();
    }

    public XsdSimpleContent getSimpleContent() {
        return this.simpleContent;
    }

    public XsdComplexContent getComplexContent() {
        return this.complexContent;
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public boolean isElementAbstract() {
        return this.elementAbstract;
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdComplexType.xsdParseSkeleton(node, new XsdComplexType(parser, XsdComplexType.convertNodeMap(node.getAttributes())));
    }

    public void setChildElement(ReferenceBase childElement) {
        this.childElement = childElement;
    }

    public void setComplexContent(XsdComplexContent complexContent) {
        this.complexContent = complexContent;
    }

    public void setSimpleContent(XsdSimpleContent simpleContent) {
        this.simpleContent = simpleContent;
    }

    public String getBlock() {
        return this.block.getValue();
    }

    public XsdGroup getChildAsGroup() {
        return this.childElement.getElement() instanceof XsdGroup ? (XsdGroup)this.childElement.getElement() : null;
    }

    public XsdAll getChildAsAll() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsdAll((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    public XsdChoice getChildAsChoice() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsChoice((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    public XsdSequence getChildAsSequence() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsSequence((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    private boolean childrenIsMultipleElement() {
        return this.childElement.getElement() instanceof XsdMultipleElements;
    }
}

