/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.enums.BlockEnum;
import org.xmlet.xsdparser.xsdelements.enums.FinalEnum;
import org.xmlet.xsdparser.xsdelements.enums.FormEnum;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdElementVisitor;

public class XsdElement
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:element";
    public static final String XS_TAG = "xs:element";
    private XsdElementVisitor visitor = new XsdElementVisitor(this);
    private ReferenceBase complexType;
    private ReferenceBase simpleType;
    private ReferenceBase type;
    private ReferenceBase substitutionGroup;
    private String defaultObj;
    private String fixed;
    private FormEnum form;
    private boolean nillable;
    private boolean abstractObj;
    private BlockEnum block;
    private FinalEnum finalObj;
    private Integer minOccurs;
    private String maxOccurs;
    private static String xsdElementIsXsdSchema = "xsd:element is a xsd:schema element.";

    public XsdElement(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        String typeString = attributesMap.get("type");
        if (typeString != null) {
            if (XsdParserCore.getXsdTypesToJava().containsKey(typeString)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", typeString);
                this.type = ReferenceBase.createFromXsd(new XsdComplexType(this, this.parser, attributes));
            } else {
                this.type = new UnsolvedReference(typeString, new XsdElement(this, this.parser, new HashMap<String, String>()));
                parser.addUnsolvedReference((UnsolvedReference)this.type);
            }
        }
        String formDefault = AttributeValidations.getFormDefaultValue(this.parent);
        String blockDefault = AttributeValidations.getBlockDefaultValue(this.parent);
        String finalDefault = AttributeValidations.getFinalDefaultValue(this.parent);
        String substitutionGroup = attributesMap.getOrDefault("substitutionGroup", null);
        if (substitutionGroup != null) {
            this.substitutionGroup = new UnsolvedReference(substitutionGroup, new XsdElement(this, this.parser, new HashMap<String, String>()));
            parser.addUnsolvedReference((UnsolvedReference)this.substitutionGroup);
        }
        this.defaultObj = attributesMap.getOrDefault("default", this.defaultObj);
        this.fixed = attributesMap.getOrDefault("fixed", this.fixed);
        this.form = AttributeValidations.belongsToEnum(FormEnum.QUALIFIED, attributesMap.getOrDefault("form", formDefault));
        this.nillable = AttributeValidations.validateBoolean(attributesMap.getOrDefault("nillable", "false"));
        this.abstractObj = AttributeValidations.validateBoolean(attributesMap.getOrDefault("abstract", "false"));
        this.block = AttributeValidations.belongsToEnum(BlockEnum.ALL, attributesMap.getOrDefault("block", blockDefault));
        this.finalObj = AttributeValidations.belongsToEnum(FinalEnum.ALL, attributesMap.getOrDefault("final", finalDefault));
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", attributesMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.maxOccursValidation(XSD_TAG, attributesMap.getOrDefault("maxOccurs", "1"));
    }

    public XsdElement(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> elementFieldsMapParam) {
        this(parser, elementFieldsMapParam);
        this.setParent(parent);
    }

    @Override
    public void validateSchemaRules() {
        super.validateSchemaRules();
        this.rule2();
        this.rule3();
        this.rule4();
        this.rule5();
        this.rule6();
        this.rule7();
    }

    private void rule7() {
        if (this.parent instanceof XsdSchema && this.attributesMap.containsKey("form")) {
            throw new ParsingException("xsd:element element: The form attribute can only be present when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    private void rule6() {
    }

    private void rule5() {
    }

    private void rule4() {
        if (!(this.parent instanceof XsdSchema) && this.substitutionGroup != null) {
            throw new ParsingException("xsd:element element: The substitutionGroup attribute can only be present when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    private void rule3() {
        if (this.parent instanceof XsdSchema && this.attributesMap.containsKey("ref")) {
            throw new ParsingException("xsd:element element: The ref attribute cannot be present when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    private void rule2() {
        if (this.parent instanceof XsdSchema && this.name == null) {
            throw new ParsingException("xsd:element element: The name attribute is required when the parent of the " + xsdElementIsXsdSchema);
        }
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdElementVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public XsdElement clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("type");
        placeHolderAttributes.remove("ref");
        XsdElement elementCopy = new XsdElement(this.parent, this.parser, placeHolderAttributes);
        elementCopy.simpleType = this.simpleType;
        elementCopy.complexType = this.complexType;
        elementCopy.type = this.type;
        return elementCopy;
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        boolean isComplexOrSimpleType;
        super.replaceUnsolvedElements(element);
        XsdNamedElements elem = element.getElement();
        boolean bl = isComplexOrSimpleType = elem instanceof XsdComplexType || elem instanceof XsdSimpleType;
        if (this.type instanceof UnsolvedReference && isComplexOrSimpleType && ((UnsolvedReference)this.type).getRef().equals(element.getName())) {
            this.type = element;
            elem.setParent(this);
        }
        if (this.substitutionGroup instanceof UnsolvedReference && elem instanceof XsdElement && ((UnsolvedReference)this.substitutionGroup).getRef().equals(element.getName())) {
            XsdElement xsdElement = (XsdElement)elem;
            this.type = xsdElement.type;
            this.simpleType = xsdElement.simpleType;
            this.complexType = xsdElement.complexType;
            this.substitutionGroup = element;
            elem.setParent(this);
        }
    }

    public XsdComplexType getXsdComplexType() {
        return this.complexType == null ? this.getXsdType() : (XsdComplexType)this.complexType.getElement();
    }

    public XsdSimpleType getXsdSimpleType() {
        return this.simpleType instanceof ConcreteElement ? (XsdSimpleType)this.simpleType.getElement() : null;
    }

    private XsdComplexType getXsdType() {
        if (this.type instanceof ConcreteElement) {
            return (XsdComplexType)this.type.getElement();
        }
        return null;
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdElement.xsdParseSkeleton(node, new XsdElement(parser, XsdElement.convertNodeMap(node.getAttributes())));
    }

    public String getFinal() {
        return this.finalObj.getValue();
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean isAbstractObj() {
        return this.abstractObj;
    }

    public void setComplexType(ReferenceBase complexType) {
        this.complexType = complexType;
    }

    public void setSimpleType(ReferenceBase simpleType) {
        this.simpleType = simpleType;
    }

    public String getBlock() {
        return this.block.getValue();
    }

    public String getForm() {
        return this.form.getValue();
    }

    public String getType() {
        if (this.type != null && this.type instanceof NamedConcreteElement) {
            return ((NamedConcreteElement)this.type).getName();
        }
        return this.attributesMap.getOrDefault("type", null);
    }

    public ReferenceBase getSubstitutionGroup() {
        return this.substitutionGroup;
    }
}

