/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdGroupVisitor;

public class XsdGroup
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:group";
    public static final String XS_TAG = "xs:group";
    private XsdGroupVisitor visitor = new XsdGroupVisitor(this);
    private XsdMultipleElements childElement;
    private Integer minOccurs;
    private String maxOccurs;

    private XsdGroup(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        this.minOccurs = AttributeValidations.validateNonNegativeInteger(XSD_TAG, "minOccurs", attributesMap.getOrDefault("minOccurs", "1"));
        this.maxOccurs = AttributeValidations.maxOccursValidation(XSD_TAG, attributesMap.getOrDefault("maxOccurs", "1"));
    }

    private XsdGroup(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        this(parser, attributesMap);
        this.setParent(parent);
    }

    @Override
    public void validateSchemaRules() {
        super.validateSchemaRules();
        this.rule2();
        this.rule3();
    }

    private void rule2() {
        if (!(this.parent instanceof XsdSchema) && this.name != null) {
            throw new ParsingException("xsd:group element: The name should only be used when the parent of the xsd:group is the xsd:schema element.");
        }
    }

    private void rule3() {
        if (this.parent instanceof XsdSchema && this.name == null) {
            throw new ParsingException("xsd:group element: The name should is required the parent of the xsd:group is the xsd:schema element.");
        }
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdGroupVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public List<ReferenceBase> getElements() {
        ArrayList<ReferenceBase> list = new ArrayList<ReferenceBase>();
        if (this.childElement != null) {
            list.add(ReferenceBase.createFromXsd(this.childElement));
        }
        return list;
    }

    @Override
    public XsdNamedElements clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("ref");
        XsdGroup elementCopy = new XsdGroup(this.parent, this.parser, placeHolderAttributes);
        if (this.childElement != null) {
            elementCopy.setChildElement(this.childElement);
        }
        return elementCopy;
    }

    public void setChildElement(XsdMultipleElements childElement) {
        this.childElement = childElement;
        childElement.getElements().forEach(childElementObj -> childElementObj.getElement().setParent(childElement));
        this.childElement.setParent(this);
    }

    public XsdMultipleElements getChildElement() {
        return this.childElement;
    }

    public XsdAll getChildAsAll() {
        return XsdMultipleElements.getChildAsdAll(this.childElement);
    }

    public XsdChoice getChildAsChoice() {
        return XsdMultipleElements.getChildAsChoice(this.childElement);
    }

    public XsdSequence getChildAsSequence() {
        return XsdMultipleElements.getChildAsSequence(this.childElement);
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdGroup.xsdParseSkeleton(node, new XsdGroup(parser, XsdGroup.convertNodeMap(node.getAttributes())));
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }
}

