/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAnnotation;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdImport;
import org.xmlet.xsdparser.xsdelements.XsdInclude;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.enums.BlockDefaultEnum;
import org.xmlet.xsdparser.xsdelements.enums.FinalDefaultEnum;
import org.xmlet.xsdparser.xsdelements.enums.FormEnum;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdSchemaVisitor;

public class XsdSchema
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:schema";
    public static final String XS_TAG = "xs:schema";
    private XsdSchemaVisitor visitor = new XsdSchemaVisitor(this);
    private FormEnum attributeFormDefault;
    private FormEnum elementFormDefault;
    private BlockDefaultEnum blockDefault;
    private FinalDefaultEnum finalDefault;
    private String targetNamespace;
    private String version;
    private String xmlns;
    private List<XsdAbstractElement> elements = new ArrayList<XsdAbstractElement>();

    private XsdSchema(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        this.attributeFormDefault = AttributeValidations.belongsToEnum(FormEnum.UNQUALIFIED, attributesMap.getOrDefault("attribtueFormDefault", FormEnum.UNQUALIFIED.getValue()));
        this.elementFormDefault = AttributeValidations.belongsToEnum(FormEnum.UNQUALIFIED, attributesMap.getOrDefault("elementFormDefault", FormEnum.UNQUALIFIED.getValue()));
        this.blockDefault = AttributeValidations.belongsToEnum(BlockDefaultEnum.DEFAULT, attributesMap.getOrDefault("blockDefault", BlockDefaultEnum.DEFAULT.getValue()));
        this.finalDefault = AttributeValidations.belongsToEnum(FinalDefaultEnum.instance, attributesMap.getOrDefault("finalDefault", FinalDefaultEnum.DEFAULT.getValue()));
        this.targetNamespace = attributesMap.getOrDefault("targetNamespace", this.targetNamespace);
        this.version = attributesMap.getOrDefault("version", this.version);
        this.xmlns = attributesMap.getOrDefault("xmlns", this.xmlns);
    }

    @Override
    public XsdAbstractElementVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public Stream<XsdAbstractElement> getXsdElements() {
        return this.elements.stream();
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.elements.stream().map(ReferenceBase::createFromXsd).collect(Collectors.toList());
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdSchema.xsdParseSkeleton(node, new XsdSchema(parser, XsdSchema.convertNodeMap(node.getAttributes())));
    }

    public void add(XsdInclude element) {
        this.elements.add(element);
    }

    public void add(XsdImport element) {
        this.elements.add(element);
    }

    public void add(XsdAnnotation element) {
        this.elements.add(element);
    }

    public void add(XsdSimpleType element) {
        this.elements.add(element);
    }

    public void add(XsdComplexType element) {
        this.elements.add(element);
    }

    public void add(XsdGroup element) {
        this.elements.add(element);
    }

    public void add(XsdAttributeGroup element) {
        this.elements.add(element);
    }

    public void add(XsdElement element) {
        this.elements.add(element);
    }

    public void add(XsdAttribute element) {
        this.elements.add(element);
    }

    public String getAttributeFormDefault() {
        return this.attributeFormDefault.getValue();
    }

    public String getElementFormDefault() {
        return this.elementFormDefault.getValue();
    }

    public String getBlockDefault() {
        return this.blockDefault.getValue();
    }

    public String getFinalDefault() {
        return this.finalDefault.getValue();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getVersion() {
        return this.version;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public Stream<XsdInclude> getChildrenIncludes() {
        return this.getXsdElements().filter(element -> element instanceof XsdInclude).map(element -> (XsdInclude)element);
    }

    public Stream<XsdImport> getChildrenImports() {
        return this.getXsdElements().filter(element -> element instanceof XsdImport).map(element -> (XsdImport)element);
    }

    public Stream<XsdAnnotation> getChildrenAnnotations() {
        return this.getXsdElements().filter(element -> element instanceof XsdAnnotation).map(element -> (XsdAnnotation)element);
    }

    public Stream<XsdSimpleType> getChildrenSimpleTypes() {
        return this.getXsdElements().filter(element -> element instanceof XsdSimpleType).map(element -> (XsdSimpleType)element);
    }

    public Stream<XsdComplexType> getChildrenComplexTypes() {
        return this.getXsdElements().filter(element -> element instanceof XsdComplexType).map(element -> (XsdComplexType)element);
    }

    public Stream<XsdGroup> getChildrenGroups() {
        return this.getXsdElements().filter(element -> element instanceof XsdGroup).map(element -> (XsdGroup)element);
    }

    public Stream<XsdAttributeGroup> getChildrenAttributeGroups() {
        return this.getXsdElements().filter(element -> element instanceof XsdAttributeGroup).map(element -> (XsdAttributeGroup)element);
    }

    public Stream<XsdElement> getChildrenElements() {
        return this.getXsdElements().filter(element -> element instanceof XsdElement).map(element -> (XsdElement)element);
    }

    public Stream<XsdAttribute> getChildrenAttributes() {
        return this.getXsdElements().filter(element -> element instanceof XsdAttribute).map(element -> (XsdAttribute)element);
    }
}

