/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdList;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdRestriction;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.XsdUnion;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.enums.SimpleTypeFinalEnum;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdSimpleTypeVisitor;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdDoubleRestrictions;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdEnumeration;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdFractionDigits;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdIntegerRestrictions;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxExclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxInclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMaxLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinExclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinInclusive;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdMinLength;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdPattern;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdStringRestrictions;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdTotalDigits;
import org.xmlet.xsdparser.xsdelements.xsdrestrictions.XsdWhiteSpace;

public class XsdSimpleType
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:simpleType";
    public static final String XS_TAG = "xs:simpleType";
    private XsdSimpleTypeVisitor visitor = new XsdSimpleTypeVisitor(this);
    private XsdRestriction restriction;
    private XsdUnion union;
    private XsdList list;
    private SimpleTypeFinalEnum finalObj;

    private XsdSimpleType(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        String finalDefault = AttributeValidations.getFinalDefaultValue(this.parent);
        this.finalObj = AttributeValidations.belongsToEnum(SimpleTypeFinalEnum.ALL, attributesMap.getOrDefault("final", finalDefault));
    }

    private XsdSimpleType(XsdAbstractElement parent, XsdParserCore parser, @NotNull Map<String, String> elementFieldsMapParam) {
        this(parser, elementFieldsMapParam);
        this.setParent(parent);
    }

    @Override
    public void validateSchemaRules() {
        super.validateSchemaRules();
        this.rule2();
        this.rule3();
    }

    private void rule2() {
        if (!(this.parent instanceof XsdSchema) && this.name != null) {
            throw new ParsingException("xsd:simpleType element: The name should only be used when the parent of the xsd:simpleType is the xsd:schema element.");
        }
    }

    private void rule3() {
        if (this.parent instanceof XsdSchema && this.name == null) {
            throw new ParsingException("xsd:simpleType element: The name should is required the parent of the xsd:simpleType is the xsd:schema element.");
        }
    }

    @Override
    public XsdSimpleTypeVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdSimpleType clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("ref");
        XsdSimpleType copy = new XsdSimpleType(this.parent, this.parser, placeHolderAttributes);
        copy.union = this.union;
        copy.list = this.list;
        copy.restriction = this.restriction;
        return copy;
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdSimpleType.xsdParseSkeleton(node, new XsdSimpleType(parser, XsdSimpleType.convertNodeMap(node.getAttributes())));
    }

    public XsdRestriction getRestriction() {
        return this.restriction;
    }

    public XsdUnion getUnion() {
        return this.union;
    }

    public XsdList getList() {
        Optional<XsdSimpleType> simpleType;
        if (this.list == null && this.union != null && (simpleType = this.union.getUnionElements().stream().filter(xsdSimpleType -> xsdSimpleType.list != null).findFirst()).isPresent()) {
            return simpleType.get().list;
        }
        return this.list;
    }

    public List<XsdRestriction> getAllRestrictions() {
        HashMap<String, XsdRestriction> restrictions = new HashMap<String, XsdRestriction>();
        Map<String, String> xsdBuiltinTypes = XsdParserCore.getXsdTypesToJava();
        if (this.restriction != null) {
            restrictions.put(xsdBuiltinTypes.get(this.restriction.getBase()), this.restriction);
        }
        if (this.union != null) {
            this.union.getUnionElements().forEach(unionMember -> {
                XsdRestriction unionMemberRestriction = unionMember.getRestriction();
                if (unionMemberRestriction != null) {
                    XsdRestriction existingRestriction = restrictions.getOrDefault(xsdBuiltinTypes.get(unionMemberRestriction.getBase()), null);
                    if (existingRestriction != null) {
                        if (this.existsRestrictionOverlap(existingRestriction, unionMemberRestriction)) {
                            throw new InvalidParameterException("The xsd file is invalid because has contradictory restrictions.");
                        }
                        this.updateExistingRestriction(existingRestriction, unionMemberRestriction);
                    } else {
                        restrictions.put((String)xsdBuiltinTypes.get(unionMemberRestriction.getBase()), unionMemberRestriction);
                    }
                }
            });
        }
        return new ArrayList<XsdRestriction>(restrictions.values());
    }

    private void updateExistingRestriction(XsdRestriction existing, XsdRestriction newRestriction) {
        XsdPattern pattern = newRestriction.getPattern();
        XsdMaxExclusive maxExclusive = newRestriction.getMaxExclusive();
        XsdMaxInclusive maxInclusive = newRestriction.getMaxInclusive();
        XsdMaxLength maxLength = newRestriction.getMaxLength();
        XsdMinExclusive minExclusive = newRestriction.getMinExclusive();
        XsdMinInclusive minInclusive = newRestriction.getMinInclusive();
        XsdMinLength minLength = newRestriction.getMinLength();
        XsdLength length = newRestriction.getLength();
        XsdFractionDigits fractionDigits = newRestriction.getFractionDigits();
        XsdTotalDigits totalDigits = newRestriction.getTotalDigits();
        XsdWhiteSpace whiteSpace = newRestriction.getWhiteSpace();
        if (pattern != null) {
            existing.setPattern(pattern);
        }
        if (maxExclusive != null) {
            existing.setMaxExclusive(maxExclusive);
        }
        if (maxInclusive != null) {
            existing.setMaxInclusive(maxInclusive);
        }
        if (maxLength != null) {
            existing.setMaxLength(maxLength);
        }
        if (minExclusive != null) {
            existing.setMinExclusive(minExclusive);
        }
        if (minInclusive != null) {
            existing.setMinInclusive(minInclusive);
        }
        if (minLength != null) {
            existing.setMinLength(minLength);
        }
        if (length != null) {
            existing.setLength(length);
        }
        if (fractionDigits != null) {
            existing.setFractionDigits(fractionDigits);
        }
        if (totalDigits != null) {
            existing.setTotalDigits(totalDigits);
        }
        if (whiteSpace != null) {
            existing.setWhiteSpace(whiteSpace);
        }
        this.updateExistingRestrictionEnumerations(existing, newRestriction);
    }

    private void updateExistingRestrictionEnumerations(XsdRestriction existing, XsdRestriction newRestriction) {
        List<XsdEnumeration> existingEnumeration = existing.getEnumeration();
        List<XsdEnumeration> newRestrictionEnumeration = newRestriction.getEnumeration();
        if (existingEnumeration == null) {
            existing.setEnumeration(newRestrictionEnumeration);
        } else if (newRestrictionEnumeration != null) {
            for (XsdEnumeration enumerationElem : newRestrictionEnumeration) {
                if (!existingEnumeration.stream().noneMatch(existingEnumerationElem -> existingEnumerationElem.getValue().equals(enumerationElem.getValue()))) continue;
                existingEnumeration.add(enumerationElem);
            }
        }
    }

    private boolean existsRestrictionOverlap(XsdRestriction existing, XsdRestriction newRestriction) {
        return XsdStringRestrictions.hasDifferentValue(existing.getPattern(), newRestriction.getPattern()) || XsdWhiteSpace.hasDifferentValue(existing.getWhiteSpace(), newRestriction.getWhiteSpace()) || XsdIntegerRestrictions.hasDifferentValue(existing.getTotalDigits(), newRestriction.getTotalDigits()) || XsdIntegerRestrictions.hasDifferentValue(existing.getFractionDigits(), newRestriction.getFractionDigits()) || XsdDoubleRestrictions.hasDifferentValue(existing.getMaxExclusive(), newRestriction.getMaxExclusive()) || XsdDoubleRestrictions.hasDifferentValue(existing.getMaxInclusive(), newRestriction.getMaxInclusive()) || XsdIntegerRestrictions.hasDifferentValue(existing.getMaxLength(), newRestriction.getMaxLength()) || XsdDoubleRestrictions.hasDifferentValue(existing.getMinExclusive(), newRestriction.getMinExclusive()) || XsdDoubleRestrictions.hasDifferentValue(existing.getMinInclusive(), newRestriction.getMinInclusive()) || XsdIntegerRestrictions.hasDifferentValue(existing.getMinLength(), newRestriction.getMinLength()) || XsdIntegerRestrictions.hasDifferentValue(existing.getLength(), newRestriction.getLength());
    }

    public void setList(XsdList list) {
        this.list = list;
    }

    public void setUnion(XsdUnion union) {
        this.union = union;
    }

    public void setRestriction(XsdRestriction restriction) {
        this.restriction = restriction;
    }

    public String getFinalObj() {
        return this.finalObj.getValue();
    }
}

