/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdUnionVisitor;

public class XsdUnion
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:union";
    public static final String XS_TAG = "xs:union";
    private XsdUnionVisitor visitor = new XsdUnionVisitor(this);
    private List<XsdSimpleType> simpleTypeList = new ArrayList<XsdSimpleType>();
    private String memberTypes;

    private XsdUnion(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap) {
        super(parser, attributesMap);
        this.memberTypes = attributesMap.getOrDefault("memberTypes", this.memberTypes);
    }

    @Override
    public XsdUnionVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    public List<XsdSimpleType> getUnionElements() {
        return this.simpleTypeList;
    }

    public List<String> getMemberTypesList() {
        return Arrays.asList(this.memberTypes.split(" "));
    }

    public static ReferenceBase parse(@NotNull XsdParserCore parser, Node node) {
        return XsdUnion.xsdParseSkeleton(node, new XsdUnion(parser, XsdUnion.convertNodeMap(node.getAttributes())));
    }

    public void add(XsdSimpleType simpleType) {
        this.simpleTypeList.add(simpleType);
    }
}

