/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAnnotatedElementsVisitor;

public abstract class AttributesVisitor
extends XsdAnnotatedElementsVisitor {
    private List<ReferenceBase> attributeGroups = new ArrayList<ReferenceBase>();
    private List<ReferenceBase> attributes = new ArrayList<ReferenceBase>();

    AttributesVisitor(XsdAnnotatedElements owner) {
        super(owner);
    }

    @Override
    public void visit(XsdAttribute attribute) {
        super.visit(attribute);
        this.attributes.add(ReferenceBase.createFromXsd(attribute));
    }

    @Override
    public void visit(XsdAttributeGroup attributeGroup) {
        super.visit(attributeGroup);
        this.attributeGroups.add(ReferenceBase.createFromXsd(attributeGroup));
    }

    public void setAttributes(List<ReferenceBase> attributes) {
        this.attributes = attributes;
    }

    public void setAttributeGroups(List<ReferenceBase> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public List<ReferenceBase> getAttributes() {
        return this.attributes;
    }

    public List<ReferenceBase> getAttributeGroups() {
        return this.attributeGroups;
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return this.attributes.stream().filter(attribute -> attribute instanceof ConcreteElement).filter(attribute -> attribute.getElement() instanceof XsdAttribute).map(attribute -> (XsdAttribute)attribute.getElement());
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroup() {
        return this.attributeGroups.stream().filter(attributeGroup -> attributeGroup instanceof ConcreteElement).map(attributeGroup -> (XsdAttributeGroup)attributeGroup.getElement());
    }

    public void replaceUnsolvedAttributes(NamedConcreteElement element) {
        if (element.getElement() instanceof XsdAttributeGroup) {
            this.attributeGroups.stream().filter(attributeGroup -> attributeGroup instanceof UnsolvedReference && ((UnsolvedReference)attributeGroup).getRef().equals(element.getName())).findFirst().ifPresent(referenceBase -> {
                this.attributeGroups.remove(referenceBase);
                this.attributeGroups.add(element);
                this.attributes.addAll(element.getElement().getElements());
                element.getElement().setParent(this.getOwner());
            });
        }
        if (element.getElement() instanceof XsdAttribute) {
            this.attributes.stream().filter(attribute -> attribute instanceof UnsolvedReference && ((UnsolvedReference)attribute).getRef().equals(element.getName())).findFirst().ifPresent(referenceBase -> {
                this.attributes.remove(referenceBase);
                this.attributes.add(element);
                element.getElement().setParent(this.getOwner());
            });
        }
    }
}

