/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.LazyIterate;
import java.util.Collection;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class LazyIterableAdapter<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;

    public LazyIterableAdapter(Iterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    public void forEach(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, procedure, parameter);
    }

    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter<T>(this.adapted.iterator());
    }

    @Override
    public <R extends Collection<T>> R into(R target) {
        Iterate.addAllIterable(this.adapted, target);
        return target;
    }

    @Override
    public LazyIterable<T> select(Predicate<? super T> predicate) {
        return LazyIterate.select(this.adapted, predicate);
    }

    @Override
    public LazyIterable<T> reject(Predicate<? super T> predicate) {
        return LazyIterate.reject(this.adapted, predicate);
    }

    @Override
    public <V> LazyIterable<V> collect(Function<? super T, ? extends V> function) {
        return LazyIterate.collect(this.adapted, function);
    }

    @Override
    public <V> LazyIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return LazyIterate.flatCollect(this.adapted, function);
    }

    @Override
    public <V> LazyIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.collectIf(this.adapted, predicate, function);
    }

    @Override
    public LazyIterable<T> take(int count) {
        return LazyIterate.take(this.adapted, count);
    }

    @Override
    public LazyIterable<T> drop(int count) {
        return LazyIterate.drop(this.adapted, count);
    }

    @Override
    public Object[] toArray() {
        return Iterate.toArray(this.adapted);
    }

    @Override
    public int size() {
        return Iterate.sizeOf(this.adapted);
    }
}

