/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.block.factory.primitive.BooleanPredicates;
import com.gs.collections.impl.lazy.primitive.CollectBooleanToObjectIterable;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBooleanIterable
implements LazyBooleanIterable {
    private final BooleanIterable delegate;
    private final BooleanPredicate predicate;

    public SelectBooleanIterable(BooleanIterable delegate, BooleanPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public BooleanIterator booleanIterator() {
        return new SelectBooleanIterator(this.delegate, this.predicate);
    }

    public void forEach(BooleanProcedure procedure) {
        this.delegate.forEach((BooleanProcedure)new IfBooleanProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.booleanIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.booleanIterator().hasNext();
    }

    public int count(BooleanPredicate predicate) {
        CountBooleanProcedure countBooleanProcedure = new CountBooleanProcedure(predicate);
        this.forEach(countBooleanProcedure);
        return countBooleanProcedure.getCount();
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(BooleanPredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.noneSatisfy(BooleanPredicates.not(predicate));
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public LazyBooleanIterable select(BooleanPredicate predicate) {
        return new SelectBooleanIterable((BooleanIterable)this, predicate);
    }

    public LazyBooleanIterable reject(BooleanPredicate predicate) {
        return new SelectBooleanIterable((BooleanIterable)this, BooleanPredicates.not(predicate));
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        BooleanIterator booleanIterator = this.booleanIterator();
        while (booleanIterator.hasNext()) {
            boolean item = booleanIterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(BooleanToObjectFunction<? extends V> function) {
        return new CollectBooleanToObjectIterable<V>((BooleanIterable)this, function);
    }

    public boolean[] toArray() {
        final boolean[] array = new boolean[this.size()];
        this.forEach(new BooleanProcedure(){
            private int index = 0;

            public void value(boolean each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            BooleanIterator iterator = this.booleanIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(boolean value) {
        return this.anySatisfy(BooleanPredicates.equal(value));
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return this;
    }

    private static final class SelectBooleanIterator
    implements BooleanIterator {
        private final BooleanIterator iterator;
        private final BooleanPredicate predicate;
        private boolean next;
        private boolean verifiedHasNext = false;

        private SelectBooleanIterator(BooleanIterable iterable, BooleanPredicate predicate) {
            this(iterable.booleanIterator(), predicate);
        }

        private SelectBooleanIterator(BooleanIterator iterator, BooleanPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                boolean temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public boolean next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfBooleanProcedure
    implements BooleanProcedure {
        private static final long serialVersionUID = 1L;
        private final BooleanProcedure procedure;

        private IfBooleanProcedure(BooleanProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(boolean each) {
            if (SelectBooleanIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountBooleanProcedure
    implements BooleanProcedure {
        private static final long serialVersionUID = 1L;
        private final BooleanPredicate predicate;
        private int counter = 0;

        private CountBooleanProcedure(BooleanPredicate predicate) {
            this.predicate = predicate;
        }

        public void value(boolean each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

