/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.multimap.list.MutableListMultimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.collection.mutable.AbstractCollectionAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.ListAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListAdapter<T>
extends AbstractCollectionAdapter<T>
implements MutableList<T> {
    public MutableList<T> clone() {
        try {
            return (MutableList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected abstract List<T> getDelegate();

    public boolean addAll(int index, Collection<? extends T> collection) {
        return this.getDelegate().addAll(index, collection);
    }

    public MutableList<T> toReversed() {
        return FastList.newList(this).reverseThis();
    }

    public MutableList<T> reverseThis() {
        int mid = this.size() >> 1;
        int j = this.size() - 1;
        int i = 0;
        while (i < mid) {
            this.swapElements(i, j);
            ++i;
            --j;
        }
        return this;
    }

    protected void swapElements(int i, int j) {
        this.set(i, this.set(j, this.get(i)));
    }

    public T get(int index) {
        return (T)this.getDelegate().get(index);
    }

    public T set(int index, T element) {
        return this.getDelegate().set(index, element);
    }

    public void add(int index, T element) {
        this.getDelegate().add(index, element);
    }

    public T remove(int index) {
        return (T)this.getDelegate().remove(index);
    }

    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    public ListIterator<T> listIterator() {
        return this.getDelegate().listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    public MutableList<T> subList(int fromIndex, int toIndex) {
        return ListAdapter.adapt(this.getDelegate().subList(fromIndex, toIndex));
    }

    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public MutableStack<T> toStack() {
        return ArrayStack.newStack(this.getDelegate());
    }

    @Override
    public abstract <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public abstract <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public abstract MutableList<T> select(Predicate<? super T> var1);

    @Override
    public abstract MutableList<T> reject(Predicate<? super T> var1);

    @Override
    public abstract <S> MutableList<S> selectInstancesOf(Class<S> var1);

    @Override
    public abstract <V> MutableList<V> collect(Function<? super T, ? extends V> var1);

    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList(this.size());
        this.forEach(new CollectBooleanProcedure<T>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        ByteArrayList result = new ByteArrayList(this.size());
        this.forEach(new CollectByteProcedure<T>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        CharArrayList result = new CharArrayList(this.size());
        this.forEach(new CollectCharProcedure<T>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList(this.size());
        this.forEach(new CollectDoubleProcedure<T>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        FloatArrayList result = new FloatArrayList(this.size());
        this.forEach(new CollectFloatProcedure<T>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        IntArrayList result = new IntArrayList(this.size());
        this.forEach(new CollectIntProcedure<T>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        LongArrayList result = new LongArrayList(this.size());
        this.forEach(new CollectLongProcedure<T>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        ShortArrayList result = new ShortArrayList(this.size());
        this.forEach(new CollectShortProcedure<T>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    @Override
    public abstract <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public abstract <V> MutableList<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public abstract PartitionMutableList<T> partition(Predicate<? super T> var1);

    @Override
    public abstract <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public abstract <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public abstract <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public abstract <S> MutableList<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public abstract MutableList<Pair<T, Integer>> zipWithIndex();
}

