/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableObjectShortMap;
import com.gs.collections.api.map.primitive.MutableObjectShortMap;
import com.gs.collections.api.map.primitive.ObjectShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableObjectShortMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectShortHashMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectShortHashMap<K>
extends AbstractImmutableObjectShortMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectShortMap<K> delegate;

    ImmutableObjectShortHashMap(ObjectShortMap<? extends K> delegate) {
        this.delegate = new ObjectShortHashMap<K>(delegate);
    }

    public ShortIterator shortIterator() {
        return this.delegate.shortIterator();
    }

    public void forEach(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortCollection select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public short max() {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    public short[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList() {
        return this.delegate.toList();
    }

    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableObjectShortMap<K> newWithKeyValue(K key, short value) {
        ObjectShortHashMap<K> map = ObjectShortHashMap.newMap();
        map.putAll((ObjectShortMap<K>)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectShortMap<K> newWithoutKey(K key) {
        ObjectShortHashMap<K> map = ObjectShortHashMap.newMap();
        map.putAll((ObjectShortMap<K>)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectShortMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectShortHashMap<K> map = ObjectShortHashMap.newMap();
        map.putAll((ObjectShortMap<K>)this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public short get(Object key) {
        return this.delegate.get(key);
    }

    public short getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    public short getIfAbsent(Object key, short ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectShortProcedure<? super K> objectShortProcedure) {
        this.delegate.forEachKeyValue(objectShortProcedure);
    }

    public ImmutableObjectShortMap<K> select(ObjectShortPredicate<? super K> objectShortPredicate) {
        return this.delegate.select(objectShortPredicate).toImmutable();
    }

    public ImmutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> objectShortPredicate) {
        return this.delegate.reject(objectShortPredicate).toImmutable();
    }

    public ImmutableObjectShortMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableShortCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectShortMap.ImmutableObjectShortMapSerializationProxy(this);
    }
}

