/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharCharPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharCharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.CharCharMap;
import com.gs.collections.api.map.primitive.ImmutableCharCharMap;
import com.gs.collections.api.map.primitive.MutableCharCharMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.block.factory.primitive.CharPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharCharMaps;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.lazy.primitive.CollectCharToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectCharIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharCharMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharCharMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharCharHashMap
implements MutableCharCharMap,
Externalizable {
    static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public CharCharHashMap() {
        this.allocateTable(16);
    }

    public CharCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public CharCharHashMap(CharCharMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1) {
        return new CharCharHashMap(1).withKeyValue(key1, value1);
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1, char key2, char value2) {
        return new CharCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1, char key2, char value2, char key3, char value3) {
        return new CharCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharCharHashMap newWithKeysValues(char key1, char value1, char key2, char value2, char key3, char value3, char key4, char value4) {
        return new CharCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap other = (CharCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || this.sentinelValues.zeroValue != other.getOrThrow('\u0000'))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || this.sentinelValues.oneValue != other.getOrThrow('\u0001'))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += '\u0000' ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += '\u0001' ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf('\u0000')).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf('\u0001')).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharCharHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(char value) {
        return this.containsValue(value);
    }

    public boolean containsAll(char ... source) {
        for (char each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        return source.allSatisfy(new CharPredicate(){

            public boolean accept(char value) {
                return CharCharHashMap.this.contains(value);
            }
        });
    }

    public void forEach(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableCharCollection select(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public char detectIfNone(CharPredicate predicate, char value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, '\u0000');
    }

    public void put(char key, char value) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(CharCharMap map) {
        map.forEachKeyValue(new CharCharProcedure(){

            public void value(char key, char value) {
                CharCharHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(char key) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(char key) {
        this.removeKey(key);
    }

    public char removeKeyIfAbsent(char key, char value) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            char oldValue = this.values[index];
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public char getIfAbsentPut(char key, char value) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPut(char key, CharFunction0 function) {
        char value;
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> char getIfAbsentPutWith(char key, CharFunction<? super P> function, P parameter) {
        char value;
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.charValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.charValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.charValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPutWithKey(char key, CharToCharFunction function) {
        char value;
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char updateValue(char key, char initialValueIfAbsent, CharToCharFunction function) {
        char value;
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public CharCharHashMap withKeyValue(char key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public CharCharHashMap withKeysValues(char key1, char value1, char key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharCharHashMap withKeysValues(char key1, char value1, char key2, char value2, char key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharCharHashMap withKeysValues(char key1, char value1, char key2, char value2, char key3, char value3, char key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public CharCharHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public CharCharHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharCharHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableCharCharMap asUnmodifiable() {
        return new UnmodifiableCharCharMap(this);
    }

    public MutableCharCharMap asSynchronized() {
        return new SynchronizedCharCharMap(this);
    }

    public ImmutableCharCharMap toImmutable() {
        return CharCharMaps.immutable.ofAll((CharCharMap)this);
    }

    public char get(char key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(char key, char ifAbsent) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public char getOrThrow(char key) {
        if (CharCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        if (CharCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(char value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (char key : this.keys) {
            if (!CharCharHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(CharCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public CharCharHashMap select(CharCharPredicate predicate) {
        CharCharHashMap result = new CharCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public CharCharHashMap reject(CharCharPredicate predicate) {
        CharCharHashMap result = new CharCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char max = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char min = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newList((CharIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readChar());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(char element) {
        int index = this.spread(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == '\u0001') {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == '\u0000') break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(char element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharCharHashMap.isEmptyKey(key) && !CharCharHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableCharCollection {
        private ValuesCollection() {
        }

        public void clear() {
            CharCharHashMap.this.clear();
        }

        public MutableCharCollection select(CharPredicate predicate) {
            return CharCharHashMap.this.select(predicate);
        }

        public MutableCharCollection reject(CharPredicate predicate) {
            return CharCharHashMap.this.reject(predicate);
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return CharCharHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return CharCharHashMap.this.collect(function);
        }

        public long sum() {
            return CharCharHashMap.this.sum();
        }

        public char max() {
            return CharCharHashMap.this.max();
        }

        public char maxIfEmpty(char defaultValue) {
            return CharCharHashMap.this.maxIfEmpty(defaultValue);
        }

        public char min() {
            return CharCharHashMap.this.min();
        }

        public char minIfEmpty(char defaultValue) {
            return CharCharHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return CharCharHashMap.this.average();
        }

        public double median() {
            return CharCharHashMap.this.median();
        }

        public char[] toSortedArray() {
            return CharCharHashMap.this.toSortedArray();
        }

        public MutableCharList toSortedList() {
            return CharCharHashMap.this.toSortedList();
        }

        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll((CharIterable)this);
        }

        public boolean contains(char value) {
            return CharCharHashMap.this.containsValue(value);
        }

        public boolean containsAll(char ... source) {
            return CharCharHashMap.this.containsAll(source);
        }

        public boolean containsAll(CharIterable source) {
            return CharCharHashMap.this.containsAll(source);
        }

        public MutableCharList toList() {
            return CharCharHashMap.this.toList();
        }

        public MutableCharSet toSet() {
            return CharCharHashMap.this.toSet();
        }

        public MutableCharBag toBag() {
            return CharCharHashMap.this.toBag();
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public boolean isEmpty() {
            return CharCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharCharHashMap.this.sentinelValues != null) {
                    if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(CharCharHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(CharCharHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < CharCharHashMap.this.keys.length; ++i) {
                    char key = CharCharHashMap.this.keys[i];
                    if (!CharCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(CharCharHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public CharIterator charIterator() {
            return CharCharHashMap.this.charIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharCharHashMap.this.forEach(procedure);
        }

        public int count(CharPredicate predicate) {
            return CharCharHashMap.this.count(predicate);
        }

        public boolean anySatisfy(CharPredicate predicate) {
            return CharCharHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(CharPredicate predicate) {
            return CharCharHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return CharCharHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(char item) {
            int oldSize = CharCharHashMap.this.size();
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && item == CharCharHashMap.this.sentinelValues.zeroValue) {
                    CharCharHashMap.this.removeKey('\u0000');
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && item == CharCharHashMap.this.sentinelValues.oneValue) {
                    CharCharHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keys.length; ++i) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keys[i]) || item != CharCharHashMap.this.values[i]) continue;
                CharCharHashMap.this.removeKey(CharCharHashMap.this.keys[i]);
            }
            return oldSize != CharCharHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = CharCharHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != CharCharHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = CharCharHashMap.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != CharCharHashMap.this.size();
        }

        public int size() {
            return CharCharHashMap.this.size();
        }

        public char[] toArray() {
            return CharCharHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableCharSet {
        private KeySet() {
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharCharHashMap.this.forEachKey(procedure);
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return false;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(char key) {
            int oldSize = CharCharHashMap.this.size();
            CharCharHashMap.this.removeKey(key);
            return oldSize != CharCharHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = CharCharHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                CharCharHashMap.this.removeKey(iterator.next());
            }
            return oldSize != CharCharHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = CharCharHashMap.this.size();
            for (char item : source) {
                CharCharHashMap.this.removeKey(item);
            }
            return oldSize != CharCharHashMap.this.size();
        }

        public void clear() {
            CharCharHashMap.this.clear();
        }

        public MutableCharSet select(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet reject(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet with(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharSet without(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharSet withAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharSet withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf('\u0000'));
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf('\u0001'));
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableCharSet asUnmodifiable() {
            return UnmodifiableCharSet.of(this);
        }

        public MutableCharSet asSynchronized() {
            return SynchronizedCharSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public char max() {
            if (CharCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char max = '\u0000';
            boolean isMaxSet = false;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                    max = '\u0000';
                    isMaxSet = true;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < '\u0001')) {
                    max = '\u0001';
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keys.length; ++i) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keys[i]) || isMaxSet && max >= CharCharHashMap.this.keys[i]) continue;
                max = CharCharHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public char maxIfEmpty(char defaultValue) {
            if (CharCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public char min() {
            if (CharCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char min = '\u0000';
            boolean isMinSet = false;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                    min = '\u0000';
                    isMinSet = true;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && (!isMinSet || '\u0001' < min)) {
                    min = '\u0001';
                    isMinSet = true;
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keys.length; ++i) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keys[i]) || isMinSet && CharCharHashMap.this.keys[i] >= min) continue;
                min = CharCharHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (CharCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public char[] toArray() {
            int size = CharCharHashMap.this.size();
            final char[] result = new char[size];
            CharCharHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(char value) {
            return CharCharHashMap.this.containsKey(value);
        }

        public boolean containsAll(char ... source) {
            for (char item : source) {
                if (CharCharHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                if (CharCharHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public CharSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableCharSet toImmutable() {
            return CharSets.immutable.withAll((CharIterable)this);
        }

        public int size() {
            return CharCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return CharCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharCharHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharSet)) {
                return false;
            }
            CharSet other = (CharSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < CharCharHashMap.this.keys.length; ++i) {
                if (!CharCharHashMap.isNonSentinel(CharCharHashMap.this.keys[i])) continue;
                result += CharCharHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharCharHashMap.this.sentinelValues != null) {
                    if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharCharHashMap.this.keys) {
                    if (!CharCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharCharHashMap.this.containsKey('\u0000')) {
                    return '\u0000';
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharCharHashMap.this.containsKey('\u0001')) {
                    return '\u0001';
                }
            }
            char[] keys = CharCharHashMap.this.keys;
            while (!CharCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyCharIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return CharCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return CharCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharCharHashMap.this.sentinelValues != null) {
                    if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharCharHashMap.this.keys) {
                    if (!CharCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public boolean contains(char key) {
            return CharCharHashMap.this.containsKey(key);
        }

        public boolean containsAll(char ... keys) {
            for (char key : keys) {
                if (CharCharHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            return source.allSatisfy(new CharPredicate(){

                public boolean accept(char key) {
                    return CharCharHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(CharProcedure procedure) {
            CharCharHashMap.this.forEachKey(procedure);
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return false;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyCharIterable select(CharPredicate predicate) {
            return new SelectCharIterable((CharIterable)this, predicate);
        }

        public LazyCharIterable reject(CharPredicate predicate) {
            return new SelectCharIterable((CharIterable)this, CharPredicates.not(predicate));
        }

        public char detectIfNone(CharPredicate predicate, char value) {
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(CharToObjectFunction<? extends V> function) {
            return new CollectCharToObjectIterable<V>((CharIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (CharCharHashMap.this.sentinelValues != null) {
                if (CharCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (CharCharHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (char key : CharCharHashMap.this.keys) {
                if (!CharCharHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public char max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            CharIterator iterator = this.charIterator();
            char max = iterator.next();
            while (iterator.hasNext()) {
                char value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public char min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            CharIterator iterator = this.charIterator();
            char min = iterator.next();
            while (iterator.hasNext()) {
                char value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public char maxIfEmpty(char defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public char[] toArray() {
            int size = CharCharHashMap.this.size();
            final char[] result = new char[size];
            CharCharHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return this;
        }
    }

    private class InternalCharIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < CharCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharCharHashMap.this.containsKey('\u0000')) {
                    return CharCharHashMap.this.get('\u0000');
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharCharHashMap.this.containsKey('\u0001')) {
                    return CharCharHashMap.this.get('\u0001');
                }
            }
            char[] keys = CharCharHashMap.this.keys;
            while (!CharCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = CharCharHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private char zeroValue;
        private char oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(char value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

