/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongLongProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableLongLongMap;
import com.gs.collections.api.map.primitive.LongLongMap;
import com.gs.collections.api.map.primitive.MutableLongLongMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.block.factory.primitive.LongPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedLongCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.LongLongMaps;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.lazy.primitive.CollectLongToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectLongIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedLongLongMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableLongLongMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongLongHashMap
implements MutableLongLongMap,
Externalizable {
    static final long EMPTY_VALUE = 0L;
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private long[] keys;
    private long[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public LongLongHashMap() {
        this.allocateTable(16);
    }

    public LongLongHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public LongLongHashMap(LongLongMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static LongLongHashMap newWithKeysValues(long key1, long value1) {
        return new LongLongHashMap(1).withKeyValue(key1, value1);
    }

    public static LongLongHashMap newWithKeysValues(long key1, long value1, long key2, long value2) {
        return new LongLongHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static LongLongHashMap newWithKeysValues(long key1, long value1, long key2, long value2, long key3, long value3) {
        return new LongLongHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static LongLongHashMap newWithKeysValues(long key1, long value1, long key2, long value2, long key3, long value3, long key4, long value4) {
        return new LongLongHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongLongMap)) {
            return false;
        }
        LongLongMap other = (LongLongMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0L) || this.sentinelValues.zeroValue != other.getOrThrow(0L))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1L) || this.sentinelValues.oneValue != other.getOrThrow(1L))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongLongHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(this.sentinelValues.zeroValue ^ this.sentinelValues.zeroValue >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(this.sentinelValues.oneValue ^ this.sentinelValues.oneValue >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ (int)(this.values[i] ^ this.values[i] >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0L)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1L)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                long key = this.keys[i];
                if (!LongLongHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(long value) {
        return this.containsValue(value);
    }

    public boolean containsAll(long ... source) {
        for (long each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy(new LongPredicate(){

            public boolean accept(long value) {
                return LongLongHashMap.this.contains(value);
            }
        });
    }

    public void forEach(LongProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableLongCollection select(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableLongCollection reject(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public long detectIfNone(LongPredicate predicate, long value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, 0L);
    }

    public void put(long key, long value) {
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(LongLongMap map) {
        map.forEachKeyValue(new LongLongProcedure(){

            public void value(long key, long value) {
                LongLongHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(long key) {
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(long key) {
        this.removeKey(key);
    }

    public long removeKeyIfAbsent(long key, long value) {
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            long oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            long oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            long oldValue = this.values[index];
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public long getIfAbsentPut(long key, long value) {
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long getIfAbsentPut(long key, LongFunction0 function) {
        long value;
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> long getIfAbsentPutWith(long key, LongFunction<? super P> function, P parameter) {
        long value;
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.longValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.longValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.longValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long getIfAbsentPutWithKey(long key, LongToLongFunction function) {
        long value;
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long updateValue(long key, long initialValueIfAbsent, LongToLongFunction function) {
        long value;
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public LongLongHashMap withKeyValue(long key1, long value1) {
        this.put(key1, value1);
        return this;
    }

    public LongLongHashMap withKeysValues(long key1, long value1, long key2, long value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongLongHashMap withKeysValues(long key1, long value1, long key2, long value2, long key3, long value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongLongHashMap withKeysValues(long key1, long value1, long key2, long value2, long key3, long value3, long key4, long value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public LongLongHashMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public LongLongHashMap withoutAllKeys(LongIterable keys) {
        keys.forEach(new LongProcedure(){

            public void value(long key) {
                LongLongHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableLongLongMap asUnmodifiable() {
        return new UnmodifiableLongLongMap(this);
    }

    public MutableLongLongMap asSynchronized() {
        return new SynchronizedLongLongMap(this);
    }

    public ImmutableLongLongMap toImmutable() {
        return LongLongMaps.immutable.ofAll((LongLongMap)this);
    }

    public long get(long key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(long key, long ifAbsent) {
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public long getOrThrow(long key) {
        if (LongLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongLongHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        if (LongLongHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (LongLongHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(long value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L);
            }
        }
        for (long key : this.keys) {
            if (!LongLongHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(LongLongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public LongLongHashMap select(LongLongPredicate predicate) {
        LongLongHashMap result = new LongLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public LongLongHashMap reject(LongLongPredicate predicate) {
        LongLongHashMap result = new LongLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long max = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long min = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeLong(0L);
                out.writeLong(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeLong(1L);
                out.writeLong(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongLongHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readLong());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        long[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongLongHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(long element) {
        int index = this.spread(element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1L) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0L) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(long element) {
        long code = element;
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new long[sizeToAllocate];
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongLongHashMap.isEmptyKey(key) && !LongLongHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableLongSet keySet() {
        return new KeySet();
    }

    public MutableLongCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableLongCollection {
        private ValuesCollection() {
        }

        public void clear() {
            LongLongHashMap.this.clear();
        }

        public MutableLongCollection select(LongPredicate predicate) {
            return LongLongHashMap.this.select(predicate);
        }

        public MutableLongCollection reject(LongPredicate predicate) {
            return LongLongHashMap.this.reject(predicate);
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            return LongLongHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
            return LongLongHashMap.this.collect(function);
        }

        public long sum() {
            return LongLongHashMap.this.sum();
        }

        public long max() {
            return LongLongHashMap.this.max();
        }

        public long maxIfEmpty(long defaultValue) {
            return LongLongHashMap.this.maxIfEmpty(defaultValue);
        }

        public long min() {
            return LongLongHashMap.this.min();
        }

        public long minIfEmpty(long defaultValue) {
            return LongLongHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return LongLongHashMap.this.average();
        }

        public double median() {
            return LongLongHashMap.this.median();
        }

        public long[] toSortedArray() {
            return LongLongHashMap.this.toSortedArray();
        }

        public MutableLongList toSortedList() {
            return LongLongHashMap.this.toSortedList();
        }

        public MutableLongCollection with(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection without(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection withAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection asUnmodifiable() {
            return UnmodifiableLongCollection.of(this);
        }

        public MutableLongCollection asSynchronized() {
            return SynchronizedLongCollection.of(this);
        }

        public ImmutableLongCollection toImmutable() {
            return LongLists.immutable.withAll((LongIterable)this);
        }

        public boolean contains(long value) {
            return LongLongHashMap.this.containsValue(value);
        }

        public boolean containsAll(long ... source) {
            return LongLongHashMap.this.containsAll(source);
        }

        public boolean containsAll(LongIterable source) {
            return LongLongHashMap.this.containsAll(source);
        }

        public MutableLongList toList() {
            return LongLongHashMap.this.toList();
        }

        public MutableLongSet toSet() {
            return LongLongHashMap.this.toSet();
        }

        public MutableLongBag toBag() {
            return LongLongHashMap.this.toBag();
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public boolean isEmpty() {
            return LongLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongLongHashMap.this.sentinelValues != null) {
                    if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(LongLongHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(LongLongHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < LongLongHashMap.this.keys.length; ++i) {
                    long key = LongLongHashMap.this.keys[i];
                    if (!LongLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(LongLongHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LongIterator longIterator() {
            return LongLongHashMap.this.longIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongLongHashMap.this.forEach(procedure);
        }

        public int count(LongPredicate predicate) {
            return LongLongHashMap.this.count(predicate);
        }

        public boolean anySatisfy(LongPredicate predicate) {
            return LongLongHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(LongPredicate predicate) {
            return LongLongHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return LongLongHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(long item) {
            int oldSize = LongLongHashMap.this.size();
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && item == LongLongHashMap.this.sentinelValues.zeroValue) {
                    LongLongHashMap.this.removeKey(0L);
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && item == LongLongHashMap.this.sentinelValues.oneValue) {
                    LongLongHashMap.this.removeKey(1L);
                }
            }
            for (int i = 0; i < LongLongHashMap.this.keys.length; ++i) {
                if (!LongLongHashMap.isNonSentinel(LongLongHashMap.this.keys[i]) || item != LongLongHashMap.this.values[i]) continue;
                LongLongHashMap.this.removeKey(LongLongHashMap.this.keys[i]);
            }
            return oldSize != LongLongHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = LongLongHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != LongLongHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = LongLongHashMap.this.size();
            for (long item : source) {
                this.remove(item);
            }
            return oldSize != LongLongHashMap.this.size();
        }

        public int size() {
            return LongLongHashMap.this.size();
        }

        public long[] toArray() {
            return LongLongHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableLongSet {
        private KeySet() {
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongLongHashMap.this.forEachKey(procedure);
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return false;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(long key) {
            int oldSize = LongLongHashMap.this.size();
            LongLongHashMap.this.removeKey(key);
            return oldSize != LongLongHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = LongLongHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                LongLongHashMap.this.removeKey(iterator.next());
            }
            return oldSize != LongLongHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = LongLongHashMap.this.size();
            for (long item : source) {
                LongLongHashMap.this.removeKey(item);
            }
            return oldSize != LongLongHashMap.this.size();
        }

        public void clear() {
            LongLongHashMap.this.clear();
        }

        public MutableLongSet select(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet reject(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet with(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongSet without(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongSet withAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongSet withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0L));
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1L));
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableLongSet asUnmodifiable() {
            return UnmodifiableLongSet.of(this);
        }

        public MutableLongSet asSynchronized() {
            return SynchronizedLongSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public long max() {
            if (LongLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 0L;
            boolean isMaxSet = false;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0L;
                    isMaxSet = true;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1L)) {
                    max = 1L;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < LongLongHashMap.this.keys.length; ++i) {
                if (!LongLongHashMap.isNonSentinel(LongLongHashMap.this.keys[i]) || isMaxSet && max >= LongLongHashMap.this.keys[i]) continue;
                max = LongLongHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public long maxIfEmpty(long defaultValue) {
            if (LongLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public long min() {
            if (LongLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min = 0L;
            boolean isMinSet = false;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0L;
                    isMinSet = true;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1L < min)) {
                    min = 1L;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < LongLongHashMap.this.keys.length; ++i) {
                if (!LongLongHashMap.isNonSentinel(LongLongHashMap.this.keys[i]) || isMinSet && LongLongHashMap.this.keys[i] >= min) continue;
                min = LongLongHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (LongLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public long[] toArray() {
            int size = LongLongHashMap.this.size();
            final long[] result = new long[size];
            LongLongHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(long value) {
            return LongLongHashMap.this.containsKey(value);
        }

        public boolean containsAll(long ... source) {
            for (long item : source) {
                if (LongLongHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                if (LongLongHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public LongSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableLongSet toImmutable() {
            return LongSets.immutable.withAll((LongIterable)this);
        }

        public int size() {
            return LongLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongLongHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongSet)) {
                return false;
            }
            LongSet other = (LongSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < LongLongHashMap.this.keys.length; ++i) {
                if (!LongLongHashMap.isNonSentinel(LongLongHashMap.this.keys[i])) continue;
                result += (int)(LongLongHashMap.this.keys[i] ^ LongLongHashMap.this.keys[i] >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongLongHashMap.this.sentinelValues != null) {
                    if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongLongHashMap.this.keys) {
                    if (!LongLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < LongLongHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongLongHashMap.this.containsKey(0L)) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongLongHashMap.this.containsKey(1L)) {
                    return 1L;
                }
            }
            long[] keys = LongLongHashMap.this.keys;
            while (!LongLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyLongIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return LongLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongLongHashMap.this.sentinelValues != null) {
                    if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongLongHashMap.this.keys) {
                    if (!LongLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public boolean contains(long key) {
            return LongLongHashMap.this.containsKey(key);
        }

        public boolean containsAll(long ... keys) {
            for (long key : keys) {
                if (LongLongHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            return source.allSatisfy(new LongPredicate(){

                public boolean accept(long key) {
                    return LongLongHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(LongProcedure procedure) {
            LongLongHashMap.this.forEachKey(procedure);
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return false;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyLongIterable select(LongPredicate predicate) {
            return new SelectLongIterable((LongIterable)this, predicate);
        }

        public LazyLongIterable reject(LongPredicate predicate) {
            return new SelectLongIterable((LongIterable)this, LongPredicates.not(predicate));
        }

        public long detectIfNone(LongPredicate predicate, long value) {
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(LongToObjectFunction<? extends V> function) {
            return new CollectLongToObjectIterable<V>((LongIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (LongLongHashMap.this.sentinelValues != null) {
                if (LongLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (LongLongHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (long key : LongLongHashMap.this.keys) {
                if (!LongLongHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public long max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            LongIterator iterator = this.longIterator();
            long max = iterator.next();
            while (iterator.hasNext()) {
                long value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public long min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            LongIterator iterator = this.longIterator();
            long min = iterator.next();
            while (iterator.hasNext()) {
                long value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public long maxIfEmpty(long defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public long[] toArray() {
            int size = LongLongHashMap.this.size();
            final long[] result = new long[size];
            LongLongHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return this;
        }
    }

    private class InternalLongIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < LongLongHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongLongHashMap.this.containsKey(0L)) {
                    return LongLongHashMap.this.get(0L);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongLongHashMap.this.containsKey(1L)) {
                    return LongLongHashMap.this.get(1L);
                }
            }
            long[] keys = LongLongHashMap.this.keys;
            while (!LongLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = LongLongHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private long zeroValue;
        private long oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(long value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

