/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableShortSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortHashSet
implements MutableShortSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final short EMPTY = 0;
    private static final short REMOVED = 1;
    private short[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public ShortHashSet() {
        this.allocateTable(16);
    }

    public ShortHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public ShortHashSet(ShortHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    public static ShortHashSet newSet(ShortIterable source) {
        if (source instanceof ShortHashSet) {
            return new ShortHashSet((ShortHashSet)source);
        }
        return ShortHashSet.newSetWith(source.toArray());
    }

    public static ShortHashSet newSetWith(short ... source) {
        ShortHashSet result = new ShortHashSet();
        result.addAll(source);
        return result;
    }

    private static boolean isBetweenZeroAndThirtyOne(short value) {
        return value >= 0 && value <= 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortSet)) {
            return false;
        }
        ShortSet other = (ShortSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        short value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                result += this.table[i];
            }
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            short value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean add(short element) {
        if (ShortHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    public boolean addAll(short ... source) {
        int oldSize = this.size();
        for (short item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    public boolean addAll(ShortIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ShortHashSet) {
            ShortHashSet hashSet = (ShortHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (short item : hashSet.table) {
                if (!ShortHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                short item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean remove(short value) {
        if (ShortHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(ShortIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ShortHashSet) {
            ShortHashSet hashSet = (ShortHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (short item : hashSet.table) {
                if (!ShortHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                short item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(short ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (short item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new short[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, (short)0);
        }
    }

    public ShortHashSet with(short element) {
        this.add(element);
        return this;
    }

    public ShortHashSet without(short element) {
        this.remove(element);
        return this;
    }

    public ShortHashSet withAll(ShortIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public ShortHashSet withoutAll(ShortIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableShortSet asUnmodifiable() {
        return new UnmodifiableShortSet(this);
    }

    public MutableShortSet asSynchronized() {
        return new SynchronizedShortSet(this);
    }

    public ImmutableShortSet toImmutable() {
        if (this.size() == 0) {
            return ShortSets.immutable.with();
        }
        if (this.size() == 1) {
            return ShortSets.immutable.with(this.shortIterator().next());
        }
        ShortHashSet mutableSet = ShortHashSet.newSetWith(this.toArray());
        return new ImmutableShortHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public short[] toArray() {
        short value;
        short[] array = new short[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            array[j] = value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    public boolean contains(short value) {
        if (ShortHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    public boolean containsAll(short ... source) {
        for (short item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void forEach(ShortProcedure procedure) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    public ShortHashSet select(ShortPredicate predicate) {
        short value;
        ShortHashSet result = new ShortHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            result.add(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public MutableShortSet reject(ShortPredicate predicate) {
        short value;
        ShortHashSet result = new ShortHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            result.add(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        short value;
        UnifiedSet target = UnifiedSet.newSet(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    public int count(ShortPredicate predicate) {
        short value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return false;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public long sum() {
        short value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (long)value;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            result += (long)value2;
        }
        return result;
    }

    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short max = (short)(31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne));
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (short value : this.table) {
            if (!ShortHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short min = (short)Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (short value : this.table) {
            if (!ShortHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    public ShortSet freeze() {
        if (this.size() == 0) {
            return ShortSets.immutable.with();
        }
        if (this.size() == 1) {
            return ShortSets.immutable.with(this.shortIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableShortHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        short value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeShort(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            out.writeShort(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readShort());
        }
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        short value;
        Object result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        short[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new short[sizeToAllocate];
    }

    int probe(short element) {
        int index = this.spread(element);
        short valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0) {
            return index;
        }
        int removedIndex = valueAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex = nextIndex + probe & this.table.length - 1;
            probe += 17;
            if (this.table[nextIndex] == element) {
                return nextIndex;
            }
            if (this.table[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.table[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(short element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        short[] copy = new short[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, Math.min(this.table.length, this.table.length));
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(short value) {
        return value != 0 && value != 1;
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int count;
        private int position;
        private short zeroToThirtyOne;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortHashSet.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32) {
                if (ShortHashSet.this.contains(this.zeroToThirtyOne)) {
                    short result = this.zeroToThirtyOne;
                    this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
                    return result;
                }
                this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
            }
            short[] table = ShortHashSet.this.table;
            while (!ShortHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            short result = table[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableShortHashSet
    implements ImmutableShortSet,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final short[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableShortHashSet(short[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use ShortSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableShortSet newSetWith(short ... elements) {
            return ShortHashSet.newSetWith(elements).toImmutable();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShortSet)) {
                return false;
            }
            ShortSet other = (ShortSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            short value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                    result += this.table[i];
                }
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public ImmutableShortSet newWith(short element) {
            return ShortHashSet.newSet((ShortIterable)this).with(element).toImmutable();
        }

        public ImmutableShortSet newWithout(short element) {
            return ShortHashSet.newSet((ShortIterable)this).without(element).toImmutable();
        }

        public ImmutableShortSet newWithAll(ShortIterable elements) {
            return ShortHashSet.newSet((ShortIterable)this).withAll(elements).toImmutable();
        }

        public ImmutableShortSet newWithoutAll(ShortIterable elements) {
            return ShortHashSet.newSet((ShortIterable)this).withoutAll(elements).toImmutable();
        }

        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean notEmpty() {
            return this.size() != 0;
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                short value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                    value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (short value2 : this.table) {
                    if (!ShortHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return new InternalShortIterator();
        }

        public short[] toArray() {
            short value;
            short[] array = new short[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                array[j] = value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        public boolean contains(short value) {
            if (ShortHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        public boolean containsAll(short ... source) {
            for (short item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public void forEach(ShortProcedure procedure) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        public ImmutableShortSet select(ShortPredicate predicate) {
            short value;
            ShortHashSet result = new ShortHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                result.add(value);
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public ImmutableShortSet reject(ShortPredicate predicate) {
            short value;
            ShortHashSet result = new ShortHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                result.add(value);
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
            short value;
            UnifiedSet target = UnifiedSet.newSet(this.size());
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                target.add(function.valueOf(value));
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                target.add(function.valueOf(value2));
            }
            return target.toImmutable();
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        public int count(ShortPredicate predicate) {
            short value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return false;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public long sum() {
            short value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (long)value;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                result += (long)value2;
            }
            return result;
        }

        public short max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short max = (short)(31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne));
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (short value : this.table) {
                if (!ShortHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        public short maxIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public short min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short min = (short)Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (short value : this.table) {
                if (!ShortHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            short value;
            Object result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        public ShortSet freeze() {
            return this;
        }

        public ImmutableShortSet toImmutable() {
            return this;
        }

        private Object writeReplace() {
            return new ImmutableShortSetSerializationProxy((ShortSet)this);
        }

        int probe(short element) {
            int index = this.spread(element);
            short valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0) {
                return index;
            }
            int removedIndex = valueAtIndex == 1 ? index : -1;
            int nextIndex = index;
            int probe = 17;
            while (true) {
                nextIndex = nextIndex + probe & this.table.length - 1;
                probe += 17;
                if (this.table[nextIndex] == element) {
                    return nextIndex;
                }
                if (this.table[nextIndex] == 1) {
                    if (removedIndex != -1) continue;
                    removedIndex = nextIndex;
                    continue;
                }
                if (this.table[nextIndex] == 0) break;
            }
            return removedIndex == -1 ? nextIndex : removedIndex;
        }

        int spread(short element) {
            int code = element;
            code ^= 0x3D ^ code >> 16;
            code += code << 3;
            code ^= code >> 4;
            code *= 668265261;
            code ^= code >> 15;
            return code & this.table.length - 1;
        }

        private class InternalShortIterator
        implements ShortIterator {
            private int count;
            private int position;
            private short zeroToThirtyOne;

            private InternalShortIterator() {
            }

            public boolean hasNext() {
                return this.count < ImmutableShortHashSet.this.size();
            }

            public short next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32) {
                    if (ImmutableShortHashSet.this.contains(this.zeroToThirtyOne)) {
                        short result = this.zeroToThirtyOne;
                        this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
                        return result;
                    }
                    this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
                }
                short[] table = ImmutableShortHashSet.this.table;
                while (!ShortHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                short result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

