/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.api.stack.primitive.IntStack;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.IntStacks;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntEmptyStack
implements ImmutableIntStack,
Serializable {
    static final ImmutableIntStack INSTANCE = new ImmutableIntEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableIntEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public void forEach(IntProcedure procedure) {
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public int peek() {
        throw new EmptyStackException();
    }

    public IntList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new IntArrayList(0);
        }
        throw new EmptyStackException();
    }

    public int peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableIntStack select(IntPredicate predicate) {
        return this;
    }

    public ImmutableIntStack reject(IntPredicate predicate) {
        return this;
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    public long sum() {
        return 0L;
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public int[] toArray() {
        return new int[0];
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableIntStack toImmutable() {
        return this;
    }

    public ImmutableIntStack push(int element) {
        return IntStacks.immutable.with(element);
    }

    public ImmutableIntStack pop() {
        throw new EmptyStackException();
    }

    public ImmutableIntStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        return stack.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalIntIterator
    implements IntIterator {
        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public int next() {
            throw new NoSuchElementException();
        }
    }
}

