/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.BooleanList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableBooleanStack;
import com.gs.collections.api.stack.primitive.MutableBooleanStack;
import com.gs.collections.impl.factory.primitive.BooleanStacks;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableBooleanStack;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedBooleanStack
implements MutableBooleanStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final MutableBooleanStack stack;

    SynchronizedBooleanStack(MutableBooleanStack stack) {
        this(stack, null);
    }

    SynchronizedBooleanStack(MutableBooleanStack stack, Object newLock) {
        this.stack = stack;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(boolean item) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pop() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanList pop(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanList peek(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peekAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peekAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.stack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    public BooleanIterator booleanIterator() {
        return this.stack.booleanIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(BooleanProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack select(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack reject(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherStack) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.equals(otherStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyBooleanIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }
    }

    public MutableBooleanStack asUnmodifiable() {
        return new UnmodifiableBooleanStack(this);
    }

    public MutableBooleanStack asSynchronized() {
        return this;
    }

    public ImmutableBooleanStack toImmutable() {
        return BooleanStacks.immutable.withAllReversed((BooleanIterable)this);
    }
}

