/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.bag.primitive.ImmutableShortBagFactory;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;

/**
 * ImmutableShortBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortBagFactoryImpl implements ImmutableShortBagFactory
{
    public ImmutableShortBag of()
    {
        return this.with();
    }

    public ImmutableShortBag with()
    {
        return ImmutableShortEmptyBag.INSTANCE;
    }

    public ImmutableShortBag of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortBag with(short one)
    {
        return new ImmutableShortSingletonBag(one);
    }

    public ImmutableShortBag of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortBag with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableShortHashBag.newBagWith(items);
    }

    public ImmutableShortBag ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortBag withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortBag)
        {
            return (ImmutableShortBag) items;
        }
        return this.with(items.toArray());
    }
}
