/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.utility.internal.primitive.ByteIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyByteIterate;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 * @since 5.0
 */
public abstract class AbstractLazyByteIterable implements LazyByteIterable
{
    public int size()
    {
        return this.count(BytePredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return ByteIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return ByteIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        ByteIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(byte value)
    {
        return this.anySatisfy(BytePredicates.equal(value));
    }

    public boolean containsAll(byte... source)
    {
        return this.containsAll(ByteSets.immutable.of(source));
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.allSatisfy(new BytePredicate()
        {
            public boolean accept(byte value)
            {
                return AbstractLazyByteIterable.this.contains(value);
            }
        });
    }

    public LazyByteIterable select(BytePredicate predicate)
    {
        return LazyByteIterate.select(this, predicate);
    }

    public LazyByteIterable reject(BytePredicate predicate)
    {
        return LazyByteIterate.select(this, BytePredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return LazyByteIterate.collect(this, function);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ByteIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(BytePredicate predicate)
    {
        return ByteIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return ByteIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return ByteIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return ByteIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return ByteIterableIterate.injectInto(this, injectedValue, function);
    }

    public long sum()
    {
        return ByteIterableIterate.sum(this);
    }

    public byte max()
    {
        return ByteIterableIterate.max(this);
    }

    public byte maxIfEmpty(byte ifEmpty)
    {
        return ByteIterableIterate.maxIfEmpty(this, ifEmpty);
    }

    public byte min()
    {
        return ByteIterableIterate.min(this);
    }

    public byte minIfEmpty(byte ifEmpty)
    {
        return ByteIterableIterate.minIfEmpty(this, ifEmpty);
    }

    public double average()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        return (double) this.sum() / (double) this.size();
    }

    public double median()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0)
        {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double) first + (double) second) / 2.0;
        }
        return (double) sortedArray[middleIndex];
    }

    public byte[] toSortedArray()
    {
        return this.toSortedList().toArray();
    }

    public MutableByteList toSortedList()
    {
        return ByteArrayList.newList(this).sortThis();
    }

    public byte[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableByteList toList()
    {
        final MutableByteList list = new ByteArrayList();
        this.forEach(new ByteProcedure()
        {
            public void value(byte each)
            {
                list.add(each);
            }
        });
        return list;
    }

    public MutableByteSet toSet()
    {
        final MutableByteSet set = new ByteHashSet();
        this.forEach(new ByteProcedure()
        {
            public void value(byte each)
            {
                set.add(each);
            }
        });
        return set;
    }

    public MutableByteBag toBag()
    {
        final MutableByteBag bag = new ByteHashBag();
        this.forEach(new ByteProcedure()
        {
            public void value(byte each)
            {
                bag.add(each);
            }
        });
        return bag;
    }

    public LazyByteIterable asLazy()
    {
        return this;
    }
}
