/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseShortIterable;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableShortEmptyList is an optimization for {@link ImmutableShortList} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyList.stg.
 */
@Immutable
final class ImmutableShortEmptyList implements ImmutableShortList, Serializable
{
    static final ImmutableShortList INSTANCE = new ImmutableShortEmptyList();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public short get(int index)
    {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public short getFirst()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public short getLast()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(short value)
    {
        return -1;
    }

    public int lastIndexOf(short value)
    {
        return -1;
    }

    public ShortIterator shortIterator()
    {
        return new InternalShortIterator();
    }

    public void forEach(ShortProcedure procedure)
    {
    }

    public void forEachWithIndex(ShortIntProcedure procedure)
    {
    }

    public int count(ShortPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public ImmutableShortList select(ShortPredicate predicate)
    {
        return this;
    }

    public ImmutableShortList reject(ShortPredicate predicate)
    {
        return this;
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public long sum()
    {
        return 0;
    }

    public short max()
    {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public short min()
    {
        throw new NoSuchElementException();
    }

    public short minIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public short[] toSortedArray()
    {
        return new short[0];
    }

    public MutableShortList toSortedList()
    {
        return new ShortArrayList();
    }

    public long dotProduct(ShortList list)
    {
        if (!list.isEmpty())
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0;
    }

    public short[] toArray()
    {
        return new short[0];
    }

    public boolean contains(short value)
    {
        return false;
    }

    public boolean containsAll(short... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.isEmpty();
    }

    public LazyShortIterable asReversed()
    {
        return ReverseShortIterable.adapt(this);
    }

    public MutableShortList toList()
    {
        return new ShortArrayList();
    }

    public MutableShortSet toSet()
    {
        return new ShortHashSet();
    }

    public MutableShortBag toBag()
    {
        return new ShortHashBag();
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public ImmutableShortList toImmutable()
    {
        return this;
    }

    public ImmutableShortEmptyList toReversed()
    {
        return this;
    }

    public ImmutableShortList newWith(short element)
    {
        return ShortLists.immutable.with(element);
    }

    public ImmutableShortList newWithout(short element)
    {
        return this;
    }

    public ImmutableShortList newWithAll(ShortIterable elements)
    {
        return ShortLists.immutable.withAll(elements);
    }

    public ImmutableShortList newWithoutAll(ShortIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof ShortList))
        {
            return false;
        }
        ShortList list = (ShortList) otherList;
        return list.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ImmutableShortList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private static class InternalShortIterator implements ShortIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public short next()
        {
            throw new NoSuchElementException();
        }
    }
}
