/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableCharBooleanMapFactory;
import com.gs.collections.api.map.primitive.ImmutableCharBooleanMap;
import com.gs.collections.api.map.primitive.CharBooleanMap;

/**
 * ImmutableCharBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharBooleanMapFactoryImpl implements ImmutableCharBooleanMapFactory
{
    public ImmutableCharBooleanMap of()
    {
        return this.with();
    }

    public ImmutableCharBooleanMap with()
    {
        return ImmutableCharBooleanEmptyMap.INSTANCE;
    }

    public ImmutableCharBooleanMap of(char key, boolean value)
    {
        return this.with(key, value);
    }

    public ImmutableCharBooleanMap with(char key, boolean value)
    {
        return new ImmutableCharBooleanSingletonMap(key, value);
    }

    public ImmutableCharBooleanMap ofAll(CharBooleanMap map)
    {
        return this.withAll(map);
    }

    public ImmutableCharBooleanMap withAll(CharBooleanMap map)
    {
        if (map instanceof ImmutableCharBooleanMap)
        {
            return (ImmutableCharBooleanMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharBooleanSingletonMap(key, map.get(key));
        }
        return new ImmutableCharBooleanHashMap(map);
    }
}
