/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableDoubleLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableDoubleLongMap;
import com.gs.collections.api.map.primitive.DoubleLongMap;

/**
 * ImmutableDoubleLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleLongMapFactoryImpl implements ImmutableDoubleLongMapFactory
{
    public ImmutableDoubleLongMap of()
    {
        return this.with();
    }

    public ImmutableDoubleLongMap with()
    {
        return ImmutableDoubleLongEmptyMap.INSTANCE;
    }

    public ImmutableDoubleLongMap of(double key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleLongMap with(double key, long value)
    {
        return new ImmutableDoubleLongSingletonMap(key, value);
    }

    public ImmutableDoubleLongMap ofAll(DoubleLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleLongMap withAll(DoubleLongMap map)
    {
        if (map instanceof ImmutableDoubleLongMap)
        {
            return (ImmutableDoubleLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleLongSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleLongHashMap(map);
    }
}
