/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntLongMap;
import com.gs.collections.api.map.primitive.IntLongMap;

/**
 * ImmutableIntLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntLongMapFactoryImpl implements ImmutableIntLongMapFactory
{
    public ImmutableIntLongMap of()
    {
        return this.with();
    }

    public ImmutableIntLongMap with()
    {
        return ImmutableIntLongEmptyMap.INSTANCE;
    }

    public ImmutableIntLongMap of(int key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableIntLongMap with(int key, long value)
    {
        return new ImmutableIntLongSingletonMap(key, value);
    }

    public ImmutableIntLongMap ofAll(IntLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntLongMap withAll(IntLongMap map)
    {
        if (map instanceof ImmutableIntLongMap)
        {
            return (ImmutableIntLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntLongSingletonMap(key, map.get(key));
        }
        return new ImmutableIntLongHashMap(map);
    }
}
