/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongShortMap;
import com.gs.collections.api.map.primitive.LongShortMap;

/**
 * ImmutableLongShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongShortMapFactoryImpl implements ImmutableLongShortMapFactory
{
    public ImmutableLongShortMap of()
    {
        return this.with();
    }

    public ImmutableLongShortMap with()
    {
        return ImmutableLongShortEmptyMap.INSTANCE;
    }

    public ImmutableLongShortMap of(long key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableLongShortMap with(long key, short value)
    {
        return new ImmutableLongShortSingletonMap(key, value);
    }

    public ImmutableLongShortMap ofAll(LongShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongShortMap withAll(LongShortMap map)
    {
        if (map instanceof ImmutableLongShortMap)
        {
            return (ImmutableLongShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongShortSingletonMap(key, map.get(key));
        }
        return new ImmutableLongShortHashMap(map);
    }
}
