/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortDoubleMap;
import com.gs.collections.api.map.primitive.ShortDoubleMap;

/**
 * ImmutableShortDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortDoubleMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortDoubleMapFactoryImpl implements ImmutableShortDoubleMapFactory
{
    public ImmutableShortDoubleMap of()
    {
        return this.with();
    }

    public ImmutableShortDoubleMap with()
    {
        return ImmutableShortDoubleEmptyMap.INSTANCE;
    }

    public ImmutableShortDoubleMap of(short key, double value)
    {
        return this.with(key, value);
    }

    public ImmutableShortDoubleMap with(short key, double value)
    {
        return new ImmutableShortDoubleSingletonMap(key, value);
    }

    public ImmutableShortDoubleMap ofAll(ShortDoubleMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortDoubleMap withAll(ShortDoubleMap map)
    {
        if (map instanceof ImmutableShortDoubleMap)
        {
            return (ImmutableShortDoubleMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableShortDoubleHashMap(map);
    }
}
