/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.util.Collections;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectLongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectLongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableObjectLongMap;
import com.gs.collections.api.map.primitive.MutableObjectLongMap;
import com.gs.collections.api.map.primitive.ObjectLongMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.ObjectLongPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.primitive.ObjectLongMaps;

/**
 * This file was automatically generated from template file unmodifiableObjectPrimitiveMap.stg.
 *
 * @since 3.2
 */
public final class UnmodifiableObjectLongMap<K>
        implements MutableObjectLongMap<K>, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectLongMap<K> map;

    UnmodifiableObjectLongMap(MutableObjectLongMap<K> map)
    {
        this.map = map;
    }

    private boolean isAbsent(long result, K key)
    {
        return result == ObjectLongHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private long getIfAbsentThrow(K key)
    {
        long result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, long value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectLongMap<? extends K> map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(K key, long value)
    {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public long getIfAbsentPut(K key, long value)
    {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPut(K key, LongFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPutWithKey(K key, LongFunction<? super K> function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> long getIfAbsentPutWith(K key, LongFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public long updateValue(K key, long initialValueIfAbsent, LongToLongFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long addToValue(K key, long toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public long get(Object key)
    {
        return this.map.get(key);
    }

    public long getOrThrow(Object key)
    {
        return this.map.getOrThrow(key);
    }

    public long getIfAbsent(Object key, long ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectLongProcedure<? super K> procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectLongMap<K> select(ObjectLongPredicate<? super K> predicate)
    {
        return this.map.select(predicate);
    }

    public MutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> predicate)
    {
        return this.map.reject(predicate);
    }

    public LongIterator longIterator()
    {
        return this.map.longIterator();
    }

    public void forEach(LongProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongCollection select(LongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableLongCollection reject(LongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(LongToObjectFunction<? extends V1> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public long max()
    {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public long[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.map.toSortedList();
    }

    public long[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(long value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.map.toList();
    }

    public MutableLongSet toSet()
    {
        return this.map.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableObjectLongMap<K> withKeyValue(K key, long value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectLongMap<K> withoutKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectLongMap<K> withoutAllKeys(Iterable<? extends K> keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectLongMap<K> asUnmodifiable()
    {
        return this;
    }

    public MutableObjectLongMap<K> asSynchronized()
    {
        return new SynchronizedObjectLongMap<K>(this);
    }

    public ImmutableObjectLongMap<K> toImmutable()
    {
        return ObjectLongMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public Set<K> keySet()
    {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ObjectLongPair<K>> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
