/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.api.stack.primitive.MutableCharStack;
import com.gs.collections.impl.factory.primitive.CharStacks;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveStack.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableCharStack
        implements MutableCharStack, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableCharStack stack;

    UnmodifiableCharStack(MutableCharStack stack)
    {
        this.stack = stack;
    }

    public void push(char item)
    {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public char pop()
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public CharList pop(int count)
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public char peek()
    {
        return this.stack.peek();
    }

    public CharList peek(int count)
    {
        return this.stack.peek(count);
    }

    public char peekAt(int index)
    {
        return this.stack.peekAt(index);
    }

    public int size()
    {
        return this.stack.size();
    }

    public boolean isEmpty()
    {
        return this.stack.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.stack.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(char value)
    {
        return this.stack.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.stack.containsAll(source);
    }

    public CharIterator charIterator()
    {
        return this.stack.charIterator();
    }

    public void forEach(CharProcedure procedure)
    {
        this.stack.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.stack.noneSatisfy(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableCharStack select(CharPredicate predicate)
    {
        return this.stack.select(predicate);
    }

    public MutableCharStack reject(CharPredicate predicate)
    {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.stack.collect(function);
    }

    public long sum()
    {
        return this.stack.sum();
    }

    public char max()
    {
        return this.stack.max();
    }

    public char min()
    {
        return this.stack.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.stack.minIfEmpty(defaultValue);
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.stack.average();
    }

    public double median()
    {
        return this.stack.median();
    }

    public MutableCharList toSortedList()
    {
        return this.stack.toSortedList();
    }

    public char[] toSortedArray()
    {
        return this.stack.toSortedArray();
    }

    public char[] toArray()
    {
        return this.stack.toArray();
    }

    @Override
    public String toString()
    {
        return this.stack.toString();
    }

    public String makeString()
    {
        return this.stack.makeString();
    }

    public String makeString(String separator)
    {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableCharList toList()
    {
        return this.stack.toList();
    }

    public MutableCharSet toSet()
    {
        return this.stack.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack)
    {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode()
    {
        return this.stack.hashCode();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public MutableCharStack asUnmodifiable()
    {
        return this;
    }

    public MutableCharStack asSynchronized()
    {
        return new SynchronizedCharStack(this);
    }

    public ImmutableCharStack toImmutable()
    {
        return CharStacks.immutable.withAllReversed(this);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectInto(injectedValue, function);
    }
}