/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableShortListFactory;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableShortArrayList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableShortEmptyList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableShortSingletonList;

public class ImmutableShortListFactoryImpl
implements ImmutableShortListFactory {
    public ImmutableShortList of() {
        return this.with();
    }

    public ImmutableShortList with() {
        return ImmutableShortEmptyList.INSTANCE;
    }

    public ImmutableShortList of(short one) {
        return this.with(one);
    }

    public ImmutableShortList with(short one) {
        return new ImmutableShortSingletonList(one);
    }

    public ImmutableShortList of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortList with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortArrayList.newListWith(items);
    }

    public ImmutableShortList ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortList withAll(ShortIterable items) {
        if (items instanceof ImmutableShortList) {
            return (ImmutableShortList)items;
        }
        return this.with(items.toArray());
    }
}

