/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.LongObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.LongObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.ImmutableLongObjectMap;
import com.gs.collections.api.map.primitive.LongObjectMap;
import com.gs.collections.api.map.primitive.MutableLongObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionIterable;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.primitive.LongObjectPair;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableLongObjectMap;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongObjectHashMap<V>
extends AbstractImmutableLongObjectMap<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongObjectMap<V> delegate;

    ImmutableLongObjectHashMap(LongObjectMap<? extends V> delegate) {
        this.delegate = new LongObjectHashMap<V>(delegate);
    }

    public V get(long key) {
        return (V)this.delegate.get(key);
    }

    public V getIfAbsent(long key, Function0<? extends V> ifAbsent) {
        return (V)this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongObjectProcedure<? super V> procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public ImmutableLongObjectMap<V> select(LongObjectPredicate<? super V> predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongObjectMap<V> reject(LongObjectPredicate<? super V> predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableLongObjectMap<V> toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public V getFirst() {
        return (V)this.delegate.getFirst();
    }

    public V getLast() {
        return (V)this.delegate.getLast();
    }

    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return this.delegate.containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        return this.delegate.containsAllArguments(elements);
    }

    public ImmutableCollection<V> select(Predicate<? super V> predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return (R)this.delegate.select(predicate, target);
    }

    public <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.selectWith(predicate, parameter).toImmutable();
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.selectWith(predicate, parameter, targetCollection);
    }

    public ImmutableCollection<V> reject(Predicate<? super V> predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return (R)this.delegate.reject(predicate, target);
    }

    public <P> ImmutableCollection<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.rejectWith(predicate, parameter).toImmutable();
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.rejectWith(predicate, parameter, targetCollection);
    }

    public PartitionIterable<V> partition(Predicate<? super V> predicate) {
        return this.delegate.partition(predicate);
    }

    public <P> PartitionIterable<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.partitionWith(predicate, parameter);
    }

    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.delegate.selectInstancesOf(clazz);
    }

    public <VV> ImmutableCollection<VV> collect(Function<? super V, ? extends VV> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.delegate.collectBoolean(booleanFunction).toImmutable();
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        return (R)this.delegate.collectBoolean(booleanFunction, target);
    }

    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        return this.delegate.collectByte(byteFunction).toImmutable();
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        return (R)this.delegate.collectByte(byteFunction, target);
    }

    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        return this.delegate.collectChar(charFunction).toImmutable();
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        return (R)this.delegate.collectChar(charFunction, target);
    }

    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.delegate.collectDouble(doubleFunction).toImmutable();
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        return (R)this.delegate.collectDouble(doubleFunction, target);
    }

    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        return this.delegate.collectFloat(floatFunction).toImmutable();
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        return (R)this.delegate.collectFloat(floatFunction, target);
    }

    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        return this.delegate.collectInt(intFunction).toImmutable();
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        return (R)this.delegate.collectInt(intFunction, target);
    }

    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        return this.delegate.collectLong(longFunction).toImmutable();
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        return (R)this.delegate.collectLong(longFunction, target);
    }

    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        return this.delegate.collectShort(shortFunction).toImmutable();
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        return (R)this.delegate.collectShort(shortFunction, target);
    }

    public <P, VV> ImmutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.delegate.collectWith(function, parameter).toImmutable();
    }

    public <VV> RichIterable<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.delegate.collectIf(predicate, function);
    }

    public <VV> RichIterable<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.flatCollect(function);
    }

    public V detect(Predicate<? super V> predicate) {
        return (V)this.delegate.detect(predicate);
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (V)this.delegate.detectWith(predicate, parameter);
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)this.delegate.detectIfNone(predicate, function);
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)this.delegate.detectWithIfNone(predicate, parameter, function);
    }

    public int count(Predicate<? super V> predicate) {
        return this.delegate.count(predicate);
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.countWith(predicate, parameter);
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.anySatisfyWith(predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.allSatisfyWith(predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.noneSatisfyWith(predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)this.delegate.injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public MutableList<V> toList() {
        return this.delegate.toList();
    }

    public MutableList<V> toSortedList() {
        return this.delegate.toSortedList();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.delegate.toSortedList(comparator);
    }

    public MutableSet<V> toSet() {
        return this.delegate.toSet();
    }

    public MutableSortedSet<V> toSortedSet() {
        return this.delegate.toSortedSet();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.delegate.toSortedSet(comparator);
    }

    public MutableBag<V> toBag() {
        return this.delegate.toBag();
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
    }

    public LazyIterable<V> asLazy() {
        return this.delegate.asLazy();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray((Object[])a);
    }

    public V min(Comparator<? super V> comparator) {
        return (V)this.delegate.min(comparator);
    }

    public V max(Comparator<? super V> comparator) {
        return (V)this.delegate.max(comparator);
    }

    public V min() {
        return (V)this.delegate.min();
    }

    public V max() {
        return (V)this.delegate.max();
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return this.delegate.sumOfInt(function);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.delegate.sumOfFloat(function);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return this.delegate.sumOfLong(function);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.delegate.sumOfDouble(function);
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public <VV> Multimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.delegate.groupBy(function);
    }

    public <VV> Multimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.groupByEach(function);
    }

    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that) {
        return this.delegate.zip(that);
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return (R)this.delegate.zip(that, target);
    }

    public RichIterable<Pair<V, Integer>> zipWithIndex() {
        return this.delegate.zipWithIndex();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return (R)this.delegate.zipWithIndex(target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        return this.delegate.chunk(size);
    }

    public <K, VV> MapIterable<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    public <K, VV> MapIterable<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.delegate.groupByEach(function, target);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.groupBy(function, target);
    }

    public <VV> MapIterable<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".groupByUniqueKey() not implemented yet");
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return (V)this.delegate.maxBy(function);
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return (V)this.delegate.minBy(function);
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedSetBy(function);
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedListBy(function);
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.delegate.flatCollect(function, target);
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collectIf(predicate, function, target);
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        return (R)this.delegate.collectWith(function, parameter, targetCollection);
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collect(function, target);
    }

    public ImmutableLongObjectMap<V> newWithKeyValue(long key, V value) {
        LongObjectHashMap<V> map = new LongObjectHashMap<V>(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongObjectMap<V> newWithoutKey(long key) {
        LongObjectHashMap map = new LongObjectHashMap(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongObjectMap<V> newWithoutAllKeys(LongIterable keys) {
        LongObjectHashMap map = new LongObjectHashMap(this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public void forEach(Procedure<? super V> procedure) {
        this.delegate.forEach(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.delegate.forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.delegate.forEachWith(procedure, parameter);
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter(this.delegate.iterator());
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public Collection<V> values() {
        return UnmodifiableMutableCollection.of(this.delegate.values());
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<LongObjectPair<V>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new AbstractImmutableLongObjectMap.ImmutableLongObjectMapSerializationProxy(this);
    }
}

