/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedIntCollection;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedIntSet
extends AbstractSynchronizedIntCollection
implements MutableIntSet {
    private static final long serialVersionUID = 1L;

    SynchronizedIntSet(MutableIntSet set) {
        super((MutableIntCollection)set);
    }

    SynchronizedIntSet(MutableIntSet set, Object newLock) {
        super((MutableIntCollection)set, newLock);
    }

    public static SynchronizedIntSet of(MutableIntSet set) {
        return new SynchronizedIntSet(set);
    }

    public static SynchronizedIntSet of(MutableIntSet set, Object lock) {
        return new SynchronizedIntSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableIntSet getMutableIntSet() {
        return (MutableIntSet)this.getIntCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntSet without(int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntSet with(int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntSet withAll(IntIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntSet withoutAll(IntIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntSet select(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntSet reject(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIntIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyIntIterableAdapter((IntIterable)this);
        }
    }

    public MutableIntSet asUnmodifiable() {
        return new UnmodifiableIntSet(this);
    }

    public MutableIntSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableIntSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntSet().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableIntSet().injectInto(injectedValue, function);
        }
    }
}

