/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility;

import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.factory.primitive.CharPredicates;
import com.gs.collections.impl.block.factory.primitive.CharToCharFunctions;
import com.gs.collections.impl.block.function.primitive.CharFunction;
import com.gs.collections.impl.block.function.primitive.CodePointFunction;
import com.gs.collections.impl.block.predicate.CodePointPredicate;
import com.gs.collections.impl.block.predicate.primitive.CharPredicate;
import com.gs.collections.impl.block.procedure.primitive.CodePointProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.tuple.Tuples;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringIterate {
    private StringIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    @Deprecated
    public static MutableList<String> csvTokensToSortedList(String string) {
        return StringIterate.tokensToSortedList(string, ",");
    }

    @Deprecated
    public static MutableList<String> csvTrimmedTokensToSortedList(String string) {
        return StringIterate.trimmedTokensToSortedList(string, ",");
    }

    public static MutableList<String> tokensToSortedList(String string, String separator) {
        return StringIterate.tokensToList(string, separator).sortThis();
    }

    public static MutableList<String> trimmedTokensToSortedList(String string, String separator) {
        return StringIterate.trimmedTokensToList(string, separator).sortThis();
    }

    @Deprecated
    public static MutableList<String> csvTokensToList(String string) {
        return StringIterate.tokensToList(string, ",");
    }

    @Deprecated
    public static MutableList<String> csvTrimmedTokensToList(String string) {
        return StringIterate.trimmedTokensToList(string, ",");
    }

    public static MutableList<String> tokensToList(String string, String separator) {
        MutableList list = Lists.mutable.of();
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            list.add((Object)token);
        }
        return list;
    }

    public static MutableList<String> trimmedTokensToList(String string, String separator) {
        return StringIterate.trimStringList(StringIterate.tokensToList(string, separator));
    }

    private static <L extends List<String>> L trimStringList(L strings) {
        ListIterator<String> listIt = strings.listIterator();
        while (listIt.hasNext()) {
            String string = listIt.next().trim();
            listIt.set(string);
        }
        return strings;
    }

    @Deprecated
    public static MutableSet<String> csvTokensToSet(String string) {
        return StringIterate.tokensToSet(string, ",");
    }

    public static MutableSet<String> tokensToSet(String string, String separator) {
        UnifiedSet<String> set = UnifiedSet.newSet();
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            set.add(token);
        }
        return set;
    }

    public static MutableMap<String, String> tokensToMap(String string) {
        return StringIterate.tokensToMap(string, "|", ":");
    }

    public static MutableMap<String, String> tokensToMap(String string, String pairSeparator, String keyValueSeparator) {
        UnifiedMap<String, String> map = UnifiedMap.newMap();
        StringTokenizer tokenizer = new StringTokenizer(string, pairSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = token.substring(0, token.indexOf(keyValueSeparator));
            String value = token.substring(token.indexOf(keyValueSeparator) + 1, token.length());
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> MutableMap<K, V> tokensToMap(String string, String separator, String keyValueSeparator, Function<String, K> keyFunction, Function<String, V> valueFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        StringTokenizer tokenizer = new StringTokenizer(string, separator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = token.substring(0, token.indexOf(keyValueSeparator));
            String value = token.substring(token.indexOf(keyValueSeparator) + 1, token.length());
            map.put(keyFunction.valueOf((Object)key), valueFunction.valueOf((Object)value));
        }
        return map;
    }

    @Deprecated
    public static MutableList<String> csvTokensToReverseSortedList(String string) {
        return StringIterate.tokensToReverseSortedList(string, ",");
    }

    public static MutableList<String> tokensToReverseSortedList(String string, String separator) {
        return StringIterate.tokensToList(string, separator).sortThis(Collections.reverseOrder());
    }

    public static void forEachToken(String string, String separator, Procedure<String> procedure) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            procedure.value((Object)token);
        }
    }

    public static <T, R> R injectIntoTokens(String string, String separator, R injectedValue, Function2<R, String, R> function) {
        Object result = injectedValue;
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            result = function.value(result, (Object)token);
        }
        return result;
    }

    public static void forEachTrimmedToken(String string, String separator, Procedure<String> procedure) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken().trim();
            procedure.value((Object)token);
        }
    }

    @Deprecated
    public static void forEach(String string, final com.gs.collections.impl.block.procedure.primitive.CharProcedure procedure) {
        StringIterate.forEach(string, new CharProcedure(){

            public void value(char each) {
                procedure.value(each);
            }
        });
    }

    public static void forEach(String string, CharProcedure procedure) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            procedure.value(string.charAt(i));
        }
    }

    public static void forEach(String string, CodePointProcedure procedure) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            procedure.value(string.codePointAt(i));
        }
    }

    public static void reverseForEach(String string, CharProcedure procedure) {
        for (int i = string.length() - 1; i >= 0; --i) {
            procedure.value(string.charAt(i));
        }
    }

    public static void reverseForEach(String string, CodePointProcedure procedure) {
        for (int i = string.length() - 1; i >= 0; --i) {
            procedure.value(string.codePointAt(i));
        }
    }

    @Deprecated
    public static int count(String string, final CharPredicate predicate) {
        return StringIterate.count(string, new com.gs.collections.api.block.predicate.primitive.CharPredicate(){

            public boolean accept(char value) {
                return predicate.accept(value);
            }
        });
    }

    public static int count(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int count = 0;
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public static int count(String string, CodePointPredicate predicate) {
        int count = 0;
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.codePointAt(i))) continue;
            ++count;
        }
        return count;
    }

    @Deprecated
    public static String collect(String string, final CharFunction function) {
        return StringIterate.collect(string, new CharToCharFunction(){

            public char valueOf(char charParameter) {
                return function.valueOf(charParameter);
            }
        });
    }

    public static String collect(String string, CharToCharFunction function) {
        int size = string.length();
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            builder.append(function.valueOf(string.charAt(i)));
        }
        return builder.toString();
    }

    public static String collect(String string, CodePointFunction function) {
        int size = string.length();
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            builder.appendCodePoint(function.valueOf(string.codePointAt(i)));
        }
        return builder.toString();
    }

    public static String englishToUpperCase(String string) {
        if (StringIterate.anySatisfy(string, CharPredicates.isLowerCase())) {
            return StringIterate.collect(string, CharToCharFunctions.toUpperCase());
        }
        return string;
    }

    public static String englishToLowerCase(String string) {
        if (StringIterate.anySatisfy(string, CharPredicates.isUpperCase())) {
            return StringIterate.collect(string, CharToCharFunctions.toLowerCase());
        }
        return string;
    }

    public static Character detect(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            char character = string.charAt(i);
            if (!predicate.accept(character)) continue;
            return Character.valueOf(character);
        }
        return null;
    }

    public static Character detectIfNone(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate, char resultIfNone) {
        Character result = StringIterate.detect(string, predicate);
        return result == null ? Character.valueOf(resultIfNone) : result;
    }

    public static Character detectIfNone(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate, String resultIfNone) {
        Character result = StringIterate.detect(string, predicate);
        return result == null ? Character.valueOf(resultIfNone.charAt(0)) : result;
    }

    public static int occurrencesOf(String string, final char value) {
        return StringIterate.count(string, new com.gs.collections.api.block.predicate.primitive.CharPredicate(){

            public boolean accept(char character) {
                return value == character;
            }
        });
    }

    public static int occurrencesOf(String string, final int value) {
        return StringIterate.count(string, new CodePointPredicate(){

            public boolean accept(int codePoint) {
                return value == codePoint;
            }
        });
    }

    public static int occurrencesOf(String string, String singleCharacter) {
        if (singleCharacter.length() != 1) {
            throw new IllegalArgumentException("Argument should be a single character: " + singleCharacter);
        }
        return StringIterate.occurrencesOf(string, singleCharacter.charAt(0));
    }

    public static boolean anySatisfy(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean anySatisfy(String string, CodePointPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (predicate.accept(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allSatisfy(String string, CodePointPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (predicate.accept(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(String string, CodePointPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String select(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; ++i) {
            char character = string.charAt(i);
            if (!predicate.accept(character)) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    public static String select(String string, CodePointPredicate predicate) {
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; ++i) {
            int codePoint = string.codePointAt(i);
            if (!predicate.accept(codePoint)) continue;
            buffer.appendCodePoint(codePoint);
        }
        return buffer.toString();
    }

    public static String reject(String string, com.gs.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; ++i) {
            char character = string.charAt(i);
            if (predicate.accept(character)) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    public static String reject(String string, CodePointPredicate predicate) {
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; ++i) {
            int codePoint = string.codePointAt(i);
            if (predicate.accept(codePoint)) continue;
            buffer.appendCodePoint(codePoint);
        }
        return buffer.toString();
    }

    public static String getLastToken(String value, String separator) {
        if (StringIterate.notEmpty(value)) {
            int lastIndex = value.lastIndexOf(separator);
            if (lastIndex > -1) {
                return value.substring(lastIndex + separator.length());
            }
            return value;
        }
        return value == null ? null : "";
    }

    public static String getFirstToken(String value, String separator) {
        if (StringIterate.notEmpty(value)) {
            int firstIndex = value.indexOf(separator);
            if (firstIndex > -1) {
                return value.substring(0, firstIndex);
            }
            return value;
        }
        return value == null ? null : "";
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmptyOrWhitespace(String string) {
        return StringIterate.isEmpty(string) || StringIterate.isWhitespace(string);
    }

    private static boolean isWhitespace(String string) {
        return StringIterate.allSatisfy(string, CodePointPredicate.IS_WHITESPACE);
    }

    public static boolean isNumber(String string) {
        return StringIterate.charactersSatisfy(string, CodePointPredicate.IS_DIGIT);
    }

    public static boolean isAlphaNumeric(String string) {
        return StringIterate.charactersSatisfy(string, CodePointPredicate.IS_LETTER_OR_DIGIT);
    }

    private static boolean charactersSatisfy(String string, CodePointPredicate predicate) {
        return !"".equals(string) && StringIterate.allSatisfy(string, predicate);
    }

    public static boolean notEmpty(String string) {
        return !StringIterate.isEmpty(string);
    }

    public static boolean notEmptyOrWhitespace(String string) {
        return !StringIterate.isEmptyOrWhitespace(string);
    }

    public static String repeat(String template, int repeatTimes) {
        StringBuilder buf = new StringBuilder(template.length() * repeatTimes);
        for (int i = 0; i < repeatTimes; ++i) {
            buf.append(template);
        }
        return buf.toString();
    }

    public static String repeat(char c, int repeatTimes) {
        StringBuilder buf = new StringBuilder(repeatTimes);
        for (int i = 0; i < repeatTimes; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static String padOrTrim(String message, int targetLength) {
        int messageLength = message.length();
        if (messageLength >= targetLength) {
            return message.substring(0, targetLength);
        }
        return message + StringIterate.repeat(' ', targetLength - messageLength);
    }

    public static MutableList<Character> toList(String string) {
        FastList<Character> characters = FastList.newList(string.length());
        StringIterate.forEach(string, new AddCharacterToCollection(characters));
        return characters;
    }

    public static MutableList<Character> toLowercaseList(String string) {
        FastList<Character> characters = FastList.newList();
        StringIterate.forEach(string, new AddLowercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableList<Character> toUppercaseList(String string) {
        FastList<Character> characters = FastList.newList();
        StringIterate.forEach(string, new AddUppercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableBag<Character> toBag(String string) {
        HashBag<Character> characters = HashBag.newBag();
        StringIterate.forEach(string, new AddCharacterToCollection(characters));
        return characters;
    }

    public static MutableBag<Character> toLowercaseBag(String string) {
        HashBag<Character> characters = HashBag.newBag();
        StringIterate.forEach(string, new AddLowercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableBag<Character> toUppercaseBag(String string) {
        HashBag<Character> characters = HashBag.newBag();
        StringIterate.forEach(string, new AddUppercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableSet<Character> toSet(String string) {
        UnifiedSet<Character> characters = UnifiedSet.newSet();
        StringIterate.forEach(string, new AddCharacterToCollection((MutableCollection)characters));
        return characters;
    }

    @Deprecated
    public static MutableSet<Character> asUppercaseSet(String string) {
        return StringIterate.toUppercaseSet(string);
    }

    public static MutableSet<Character> toUppercaseSet(String string) {
        UnifiedSet<Character> characters = UnifiedSet.newSet();
        StringIterate.forEach(string, new AddUppercaseCharacterToCollection((MutableCollection)characters));
        return characters;
    }

    @Deprecated
    public static MutableSet<Character> asLowercaseSet(String string) {
        return StringIterate.toLowercaseSet(string);
    }

    public static MutableSet<Character> toLowercaseSet(String string) {
        UnifiedSet<Character> characters = UnifiedSet.newSet();
        StringIterate.forEach(string, new AddLowercaseCharacterToCollection((MutableCollection)characters));
        return characters;
    }

    public static Twin<String> splitAtIndex(String aString, int index) {
        return Tuples.twin(aString.substring(0, index), aString.substring(index, aString.length()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddUppercaseCharacterToCollection
    implements CharProcedure {
        private final MutableCollection<Character> characters;

        private AddUppercaseCharacterToCollection(MutableCollection<Character> characters) {
            this.characters = characters;
        }

        public void value(char character) {
            this.characters.add((Object)Character.valueOf(Character.toUpperCase(character)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddLowercaseCharacterToCollection
    implements CharProcedure {
        private final MutableCollection<Character> characters;

        private AddLowercaseCharacterToCollection(MutableCollection<Character> characters) {
            this.characters = characters;
        }

        public void value(char character) {
            this.characters.add((Object)Character.valueOf(Character.toLowerCase(character)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddCharacterToCollection
    implements CharProcedure {
        private final MutableCollection<Character> characters;

        private AddCharacterToCollection(MutableCollection<Character> characters) {
            this.characters = characters;
        }

        public void value(char character) {
            this.characters.add((Object)Character.valueOf(character));
        }
    }
}

