/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bimap.immutable;

import com.gs.collections.api.bimap.ImmutableBiMap;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.impl.bimap.mutable.HashBiMap;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableBiMapSerializationProxy<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableBiMap<K, V> biMap;

    public ImmutableBiMapSerializationProxy() {
    }

    ImmutableBiMapSerializationProxy(ImmutableBiMap<K, V> biMap) {
        this.biMap = biMap;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.biMap.size());
        try {
            this.biMap.forEachKeyValue((Procedure2)new CheckedProcedure2<K, V>(){

                @Override
                public void safeValue(K key, V value) throws IOException {
                    out.writeObject(key);
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        HashBiMap deserializedBiMap = new HashBiMap(size);
        for (int i = 0; i < size; ++i) {
            if (deserializedBiMap.put(in.readObject(), in.readObject()) == null) continue;
            throw new IllegalStateException();
        }
        this.biMap = deserializedBiMap.toImmutable();
    }

    protected Object readResolve() {
        return this.biMap;
    }
}

