/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.iterator;

import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.tuple.Tuples;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ZipIterator<X, Y>
implements Iterator<Pair<X, Y>> {
    private final Iterator<X> xIterator;
    private final Iterator<Y> yIterator;

    public ZipIterator(Iterable<X> xs, Iterable<Y> ys) {
        this.xIterator = xs.iterator();
        this.yIterator = ys.iterator();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean hasNext() {
        return this.xIterator.hasNext() && this.yIterator.hasNext();
    }

    @Override
    public Pair<X, Y> next() {
        return Tuples.pair(this.xIterator.next(), this.yIterator.next());
    }
}

