/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatFloatMap;
import com.gs.collections.api.map.primitive.ImmutableFloatFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatFloatMaps;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatFloatSingletonMap
implements ImmutableFloatFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final float key1;
    private final float value1;

    ImmutableFloatFloatSingletonMap(float key1, float value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public float get(float key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(float key, float ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public float getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    public boolean containsValue(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    public void forEachValue(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(FloatFloatProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<FloatFloatPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableFloatFloatMap select(FloatFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatFloatHashMap().toImmutable();
    }

    public ImmutableFloatFloatMap reject(FloatFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatFloatHashMap().toImmutable() : FloatFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableFloatFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)FloatFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum() {
        return this.value1;
    }

    public float min() {
        return this.value1;
    }

    public float max() {
        return this.value1;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.value1;
    }

    public float minIfEmpty(float defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public float[] toSortedArray() {
        return new float[]{this.value1};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatArrayList.newListWith(this.value1).toImmutable() : new FloatArrayList().toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? new FloatArrayList().toImmutable() : FloatArrayList.newListWith(this.value1).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public float[] toArray() {
        return new float[]{this.value1};
    }

    public boolean contains(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.value1);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.value1);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.value1);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableFloatFloatMap newWithKeyValue(float key, float value) {
        return FloatFloatMaps.immutable.withAll((FloatFloatMap)FloatFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableFloatFloatMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatFloatMaps.immutable.with() : this;
    }

    public ImmutableFloatFloatMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatFloatMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of((MutableFloatCollection)FloatArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatFloatMap)) {
            return false;
        }
        FloatFloatMap map = (FloatFloatMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Float.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ Float.floatToIntBits(this.value1);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

