/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.set.sorted;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.set.MutableSetMultimap;
import com.gs.collections.api.multimap.sortedset.ImmutableSortedSetMultimap;
import com.gs.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import com.gs.collections.api.multimap.sortedset.SortedSetMultimap;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.AbstractSynchronizedPutMultimap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.multimap.set.sorted.ImmutableSortedSetMultimapImpl;
import com.gs.collections.impl.multimap.set.sorted.TreeSortedSetMultimap;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizedPutTreeSortedSetMultimap<K, V>
extends AbstractSynchronizedPutMultimap<K, V, MutableSortedSet<V>>
implements MutableSortedSetMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 2L;
    private Comparator<? super V> comparator;

    public SynchronizedPutTreeSortedSetMultimap() {
        this.comparator = null;
    }

    public SynchronizedPutTreeSortedSetMultimap(Comparator<? super V> comparator) {
        this.comparator = comparator;
    }

    public SynchronizedPutTreeSortedSetMultimap(Multimap<? extends K, ? extends V> multimap) {
        this.comparator = multimap instanceof SortedSetMultimap ? ((SortedSetMultimap)multimap).comparator() : null;
        this.putAll(multimap);
    }

    public SynchronizedPutTreeSortedSetMultimap(Pair<K, V> ... pairs) {
        this();
        ArrayIterate.forEach(pairs, new Procedure<Pair<K, V>>(){

            public void value(Pair<K, V> pair) {
                SynchronizedPutTreeSortedSetMultimap.this.put(pair.getOne(), pair.getTwo());
            }
        });
    }

    public SynchronizedPutTreeSortedSetMultimap(Iterable<Pair<K, V>> inputIterable) {
        this();
        Iterate.forEach(inputIterable, new Procedure<Pair<K, V>>(){

            public void value(Pair<K, V> pair) {
                SynchronizedPutTreeSortedSetMultimap.this.add(pair);
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.comparator);
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.comparator = (Comparator)in.readObject();
        super.readExternal(in);
    }

    public static <K, V> SynchronizedPutTreeSortedSetMultimap<K, V> newMultimap(Comparator<? super V> comparator) {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>(comparator);
    }

    public static <K, V> SynchronizedPutTreeSortedSetMultimap<K, V> newMultimap() {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>();
    }

    public static <K, V> SynchronizedPutTreeSortedSetMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedPutTreeSortedSetMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>(pairs);
    }

    public static <K, V> SynchronizedPutTreeSortedSetMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableSortedSet<V> createCollection() {
        return TreeSortedSet.newSet(this.comparator);
    }

    public SynchronizedPutTreeSortedSetMultimap<K, V> newEmpty() {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>();
    }

    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    public MutableSortedSetMultimap<K, V> toMutable() {
        return new SynchronizedPutTreeSortedSetMultimap<K, V>(this);
    }

    public ImmutableSortedSetMultimap<K, V> toImmutable() {
        final UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableSortedSet<V>>(){

            public void value(K key, MutableSortedSet<V> set) {
                map.put(key, (Object)set.toImmutable());
            }
        });
        return new ImmutableSortedSetMultimapImpl(map, this.comparator());
    }

    public TreeSortedSetMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.selectKeysValues(predicate, TreeSortedSetMultimap.newMultimap(this.comparator));
    }

    public TreeSortedSetMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.rejectKeysValues(predicate, TreeSortedSetMultimap.newMultimap(this.comparator));
    }

    public TreeSortedSetMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.selectKeysMultiValues(predicate, TreeSortedSetMultimap.newMultimap(this.comparator));
    }

    public TreeSortedSetMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.rejectKeysMultiValues(predicate, TreeSortedSetMultimap.newMultimap(this.comparator));
    }

    public <K2, V2> HashBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <V2> FastListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, FastListMultimap.newMultimap());
    }

    public MutableSetMultimap<V, K> flip() {
        return Iterate.flip(this);
    }
}

