/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableDoubleSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleEmptySet
implements ImmutableDoubleSet,
Serializable {
    static final ImmutableDoubleSet INSTANCE = new ImmutableDoubleEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableDoubleSet newWith(double element) {
        return new ImmutableDoubleSingletonSet(element);
    }

    public ImmutableDoubleSet newWithout(double element) {
        return this;
    }

    public ImmutableDoubleSet newWithAll(DoubleIterable elements) {
        return DoubleSets.immutable.withAll(elements);
    }

    public ImmutableDoubleSet newWithoutAll(DoubleIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(double ... elements) {
        return elements.length == 0;
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public ImmutableDoubleSet select(DoublePredicate predicate) {
        return this;
    }

    public ImmutableDoubleSet reject(DoublePredicate predicate) {
        return this;
    }

    public <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public double sum() {
        return 0.0;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleSet)) {
            return false;
        }
        DoubleSet set = (DoubleSet)obj;
        return set.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public DoubleSet freeze() {
        return this;
    }

    public ImmutableDoubleSet toImmutable() {
        return this;
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public double[] toArray() {
        return new double[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }
}

