/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.api.stack.primitive.IntStack;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedIntProcedure;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.IntStacks;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntArrayStack
implements ImmutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IntArrayList delegate;

    private ImmutableIntArrayStack(int[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new IntArrayList(newElements);
    }

    private ImmutableIntArrayStack(IntArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use IntStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableIntArrayStack newStack(IntIterable iterable) {
        return new ImmutableIntArrayStack(iterable.toArray());
    }

    public static ImmutableIntArrayStack newStackWith(int ... elements) {
        int[] newArray = new int[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableIntArrayStack(newArray);
    }

    public static ImmutableIntArrayStack newStackFromTopToBottom(int ... items) {
        return new ImmutableIntArrayStack(IntArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableIntArrayStack newStackFromTopToBottom(IntIterable items) {
        return new ImmutableIntArrayStack(IntArrayList.newList(items).reverseThis());
    }

    public ImmutableIntStack push(int item) {
        IntArrayList newDelegate = IntArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableIntArrayStack(newDelegate);
    }

    public ImmutableIntStack pop() {
        IntArrayList newDelegate = IntArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return IntStacks.immutable.with(newDelegate.toArray());
    }

    public ImmutableIntStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        IntArrayList newDelegate = IntArrayList.newList(this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return IntStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int peek() {
        return this.delegate.getLast();
    }

    public IntList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new IntArrayList();
        }
        IntArrayList subList = new IntArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public int peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.delegate.asReversed().intIterator());
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public ImmutableIntStack select(IntPredicate predicate) {
        return IntStacks.immutable.withAllReversed((IntIterable)this.delegate.asReversed().select(predicate));
    }

    public ImmutableIntStack reject(IntPredicate predicate) {
        return IntStacks.immutable.withAllReversed((IntIterable)this.delegate.asReversed().reject(predicate));
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.delegate.asReversed().collect(function));
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.max();
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.min();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public int[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(int value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableIntStack toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyIntIterable iterable = this.delegate.asReversed();
        IntIterator iterator = iterable.intIterator();
        while (iterator.hasNext()) {
            int item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableIntStackSerializationProxy((IntStack)this);
    }

    private static class ImmutableIntStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntStack stack;

        public ImmutableIntStackSerializationProxy() {
        }

        protected ImmutableIntStackSerializationProxy(IntStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((IntProcedure)new CheckedIntProcedure(){

                    public void safeValue(int item) throws IOException {
                        out.writeInt(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntArrayList deserializedDelegate = new IntArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readInt());
            }
            this.stack = ImmutableIntArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

