/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.lazy.ChunkIterable;
import com.gs.collections.impl.lazy.CollectIterable;
import com.gs.collections.impl.lazy.CompositeIterable;
import com.gs.collections.impl.lazy.DistinctIterable;
import com.gs.collections.impl.lazy.DropIterable;
import com.gs.collections.impl.lazy.FlatCollectIterable;
import com.gs.collections.impl.lazy.LazyIterableAdapter;
import com.gs.collections.impl.lazy.RejectIterable;
import com.gs.collections.impl.lazy.SelectInstancesOfIterable;
import com.gs.collections.impl.lazy.SelectIterable;
import com.gs.collections.impl.lazy.TakeIterable;
import com.gs.collections.impl.lazy.TapIterable;
import com.gs.collections.impl.lazy.ZipIterable;
import com.gs.collections.impl.lazy.ZipWithIndexIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyIterate {
    private static final LazyIterable<?> EMPTY_ITERABLE = Lists.immutable.empty().asLazy();

    private LazyIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> LazyIterable<T> adapt(Iterable<T> iterable) {
        return new LazyIterableAdapter<T>(iterable);
    }

    public static <T> LazyIterable<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new SelectIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new RejectIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> selectInstancesOf(Iterable<?> iterable, Class<T> clazz) {
        return new SelectInstancesOfIterable<T>(iterable, clazz);
    }

    public static <T, V> LazyIterable<V> collect(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        return new CollectIterable<T, V>(iterable, function);
    }

    public static <T, V> LazyIterable<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectIterable(iterable, function);
    }

    public static <T, V> LazyIterable<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.select(iterable, predicate).collect(function);
    }

    public static <T> LazyIterable<T> take(Iterable<T> iterable, int count) {
        return new TakeIterable<T>(iterable, count);
    }

    public static <T> LazyIterable<T> drop(Iterable<T> iterable, int count) {
        return new DropIterable<T>(iterable, count);
    }

    public static <T> LazyIterable<T> distinct(Iterable<T> iterable) {
        return new DistinctIterable<T>(iterable);
    }

    public static <T> LazyIterable<T> concatenate(Iterable<T> ... iterables) {
        return CompositeIterable.with(iterables);
    }

    public static <T> LazyIterable<T> empty() {
        return EMPTY_ITERABLE;
    }

    public static <A, B> LazyIterable<Pair<A, B>> zip(Iterable<A> as, Iterable<B> bs) {
        return new ZipIterable<A, B>(as, bs);
    }

    public static <T> LazyIterable<Pair<T, Integer>> zipWithIndex(Iterable<T> iterable) {
        return new ZipWithIndexIterable<T>(iterable);
    }

    public static <T> LazyIterable<RichIterable<T>> chunk(Iterable<T> iterable, int size) {
        return new ChunkIterable<T>(iterable, size);
    }

    public static <T> LazyIterable<T> tap(Iterable<T> iterable, Procedure<? super T> procedure) {
        return new TapIterable<T>(iterable, procedure);
    }
}

