package com.google.api.gax.httpjson;

import java.io.InputStream;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_HttpRequestRunnable_RunnableResult extends HttpRequestRunnable.RunnableResult {

  private final HttpJsonMetadata responseHeaders;

  private final int statusCode;

  private final InputStream responseContent;

  private final HttpJsonMetadata trailers;

  private AutoValue_HttpRequestRunnable_RunnableResult(
      @Nullable HttpJsonMetadata responseHeaders,
      int statusCode,
      @Nullable InputStream responseContent,
      HttpJsonMetadata trailers) {
    this.responseHeaders = responseHeaders;
    this.statusCode = statusCode;
    this.responseContent = responseContent;
    this.trailers = trailers;
  }

  @Nullable
  @Override
  HttpJsonMetadata getResponseHeaders() {
    return responseHeaders;
  }

  @Override
  int getStatusCode() {
    return statusCode;
  }

  @Nullable
  @Override
  InputStream getResponseContent() {
    return responseContent;
  }

  @Override
  HttpJsonMetadata getTrailers() {
    return trailers;
  }

  @Override
  public String toString() {
    return "RunnableResult{"
        + "responseHeaders=" + responseHeaders + ", "
        + "statusCode=" + statusCode + ", "
        + "responseContent=" + responseContent + ", "
        + "trailers=" + trailers
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof HttpRequestRunnable.RunnableResult) {
      HttpRequestRunnable.RunnableResult that = (HttpRequestRunnable.RunnableResult) o;
      return (this.responseHeaders == null ? that.getResponseHeaders() == null : this.responseHeaders.equals(that.getResponseHeaders()))
          && this.statusCode == that.getStatusCode()
          && (this.responseContent == null ? that.getResponseContent() == null : this.responseContent.equals(that.getResponseContent()))
          && this.trailers.equals(that.getTrailers());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (responseHeaders == null) ? 0 : responseHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= statusCode;
    h$ *= 1000003;
    h$ ^= (responseContent == null) ? 0 : responseContent.hashCode();
    h$ *= 1000003;
    h$ ^= trailers.hashCode();
    return h$;
  }

  static final class Builder extends HttpRequestRunnable.RunnableResult.Builder {
    private HttpJsonMetadata responseHeaders;
    private int statusCode;
    private InputStream responseContent;
    private HttpJsonMetadata trailers;
    private byte set$0;
    Builder() {
    }
    @Override
    public HttpRequestRunnable.RunnableResult.Builder setResponseHeaders(HttpJsonMetadata responseHeaders) {
      this.responseHeaders = responseHeaders;
      return this;
    }
    @Override
    public HttpRequestRunnable.RunnableResult.Builder setStatusCode(int statusCode) {
      this.statusCode = statusCode;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public HttpRequestRunnable.RunnableResult.Builder setResponseContent(InputStream responseContent) {
      this.responseContent = responseContent;
      return this;
    }
    @Override
    public HttpRequestRunnable.RunnableResult.Builder setTrailers(HttpJsonMetadata trailers) {
      if (trailers == null) {
        throw new NullPointerException("Null trailers");
      }
      this.trailers = trailers;
      return this;
    }
    @Override
    public HttpRequestRunnable.RunnableResult build() {
      if (set$0 != 1
          || this.trailers == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" statusCode");
        }
        if (this.trailers == null) {
          missing.append(" trailers");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_HttpRequestRunnable_RunnableResult(
          this.responseHeaders,
          this.statusCode,
          this.responseContent,
          this.trailers);
    }
  }

}
